/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.logstash.Event;
import org.logstash.dissect.Delimiter;
import org.logstash.dissect.FieldDelimiterHolder;
import org.logstash.dissect.ValueRef;
import org.logstash.dissect.ValueResolver;
import org.logstash.dissect.fields.Field;
import org.logstash.dissect.fields.FieldComparator;
import org.logstash.dissect.fields.FieldFactory;

public class Dissector {
    private static final Pattern DELIMITER_FIELD_PATTERN = Pattern.compile("(.*?)%\\{([^}]*?)}", 32);
    private final List<Field> fields = new ArrayList<Field>(10);
    private final List<Field> saveableFields = new ArrayList<Field>(10);
    private int initialOffset = 0;

    public static Dissector create(String mapping) {
        Dissector dissector = new Dissector();
        dissector.handleMapping(mapping);
        return dissector;
    }

    private void handleMapping(String mapping) {
        if (mapping.isEmpty()) {
            throw new IllegalArgumentException("The mapping string cannot be empty");
        }
        List<FieldDelimiterHolder> list = this.createFieldAssociations(mapping);
        this.createFieldList(list);
    }

    private List<FieldDelimiterHolder> createFieldAssociations(String mapping) {
        ArrayList<FieldDelimiterHolder> list = new ArrayList<FieldDelimiterHolder>(10);
        Matcher matcher = DELIMITER_FIELD_PATTERN.matcher(mapping);
        int fieldIndex = 0;
        while (matcher.find()) {
            Delimiter delimiter = Delimiter.create(matcher.group(1));
            FieldDelimiterHolder temp = new FieldDelimiterHolder(fieldIndex, matcher.group(2));
            temp.setPrevious(delimiter);
            if (list.isEmpty()) {
                if (delimiter.size() > 0) {
                    this.initialOffset = delimiter.size();
                    delimiter.setGreedy(true);
                }
            } else {
                ((FieldDelimiterHolder)list.get(fieldIndex - 1)).setNext(delimiter);
            }
            list.add(fieldIndex, temp);
            ++fieldIndex;
        }
        return list;
    }

    private void createFieldList(Iterable<FieldDelimiterHolder> list) {
        for (FieldDelimiterHolder holder : list) {
            Field field = FieldFactory.create(holder.getId(), holder.getName(), holder.getPrevious(), holder.getNext());
            this.fields.add(field);
            if (!field.saveable()) continue;
            this.saveableFields.add(field);
        }
        this.saveableFields.sort(new FieldComparator());
    }

    public final int dissect(byte[] source, Map<String, Object> keyValueMap) {
        int pos;
        if (this.fields.isEmpty() || source == null || source.length == 0) {
            pos = -1;
        } else {
            ValueRef[] valueRefs = this.createValueRefArray();
            pos = this.dissectValues(source, valueRefs);
            ValueResolver resolver = new ValueResolver(source, valueRefs);
            for (Field field : this.saveableFields) {
                field.append(keyValueMap, resolver);
            }
        }
        return pos;
    }

    public final int dissect(byte[] source, Event event) {
        int pos;
        if (this.fields.isEmpty() || source.length == 0) {
            pos = -1;
        } else {
            ValueRef[] valueRefs = this.createValueRefArray();
            pos = this.dissectValues(source, valueRefs);
            ValueResolver resolver = new ValueResolver(source, valueRefs);
            for (Field field : this.saveableFields) {
                field.append(event, resolver);
            }
        }
        return pos;
    }

    private ValueRef[] createValueRefArray() {
        ValueRef[] array = new ValueRef[this.fields.size()];
        for (Field field : this.fields) {
            array[field.id()] = new ValueRef(field.name());
        }
        return array;
    }

    private int dissectValues(byte[] source, ValueRef[] fieldValueRefs) {
        Position position = new Position(source, this.initialOffset);
        int numFields = this.fields.size();
        int lastFieldIndex = numFields - 1;
        for (int idx = 0; idx < lastFieldIndex; ++idx) {
            Field field = this.fields.get(idx);
            fieldValueRefs[field.id()].clear();
            position.moveBeyondDelimiter(field.previousDelimiter());
            position.moveNext(field.nextDelimiter());
            fieldValueRefs[field.id()].update(position.start, position.length);
        }
        Field lastField = this.fields.get(lastFieldIndex);
        fieldValueRefs[lastField.id()].clear();
        position.moveBeyondDelimiter(lastField.previousDelimiter());
        position.repositionToEnd();
        fieldValueRefs[lastField.id()].update(position.start, position.length);
        return position.pos;
    }

    private static final class Position {
        int pos;
        int left;
        final byte[] source;
        int start;
        int length;

        Position(byte[] sourceBytes, int initial) {
            this.source = sourceBytes;
            this.left = initial;
            this.pos = 0;
            this.start = 0;
            this.length = 0;
        }

        void setStart() {
            this.start = this.left;
        }

        void setLength() {
            this.length = this.pos - this.left;
        }

        void repositionToEnd() {
            this.pos = this.source.length;
            this.setLength();
        }

        void moveNext(Delimiter next) {
            this.length = 0;
            this.pos = next.indexOf(this.source, this.left);
            if (this.pos > 0) {
                this.setLength();
                this.left = this.pos + next.size();
            }
        }

        void moveBeyondDelimiter(Delimiter prev) {
            if (prev == null || !prev.isGreedy()) {
                this.setStart();
            } else {
                while (true) {
                    this.pos = prev.indexOf(this.source, this.left);
                    if (this.pos != this.left) {
                        this.setStart();
                        break;
                    }
                    this.left = this.pos + prev.size();
                }
            }
        }
    }
}

