/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.beats.Batch;
import org.logstash.beats.Message;
import org.logstash.beats.Protocol;
import org.logstash.beats.V1Batch;
import org.logstash.beats.V2Batch;

public class BeatsParser
extends ByteToMessageDecoder {
    private static final Logger logger = LogManager.getLogger(BeatsParser.class);
    private Batch batch;
    private States currentState = States.READ_HEADER;
    private int requiredBytes = 0;
    private int sequence = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!this.hasEnoughBytes(in)) {
            return;
        }
        block9 : switch (1.$SwitchMap$org$logstash$beats$BeatsParser$States[this.currentState.ordinal()]) {
            case 1: {
                BeatsParser.logger.trace("Running: READ_HEADER");
                currentVersion = in.readByte();
                if (this.batch == null) {
                    if (Protocol.isVersion2(currentVersion)) {
                        this.batch = new V2Batch();
                        BeatsParser.logger.trace("Frame version 2 detected");
                    } else {
                        BeatsParser.logger.trace("Frame version 1 detected");
                        this.batch = new V1Batch();
                    }
                }
                this.transition(States.READ_FRAME_TYPE);
                break;
            }
            case 2: {
                frameType = in.readByte();
                switch (frameType) {
                    case 87: {
                        this.transition(States.READ_WINDOW_SIZE);
                        break block9;
                    }
                    case 74: {
                        this.transition(States.READ_JSON_HEADER);
                        break block9;
                    }
                    case 67: {
                        this.transition(States.READ_COMPRESSED_FRAME_HEADER);
                        break block9;
                    }
                    case 68: {
                        this.transition(States.READ_DATA_FIELDS);
                        break block9;
                    }
                }
                throw new InvalidFrameProtocolException("Invalid Frame Type, received: " + frameType);
            }
            case 3: {
                BeatsParser.logger.trace("Running: READ_WINDOW_SIZE");
                this.batch.setBatchSize((int)in.readUnsignedInt());
                if (!this.batch.isEmpty()) {
                    BeatsParser.logger.warn("New window size received but the current batch was not complete, sending the current batch");
                    out.add(this.batch);
                    this.batchComplete();
                }
                this.transition(States.READ_HEADER);
                break;
            }
            case 4: {
                BeatsParser.logger.trace("Running: READ_DATA_FIELDS");
                this.sequence = (int)in.readUnsignedInt();
                fieldsCount = (int)in.readUnsignedInt();
                if (fieldsCount <= 0) {
                    throw new InvalidFrameProtocolException("Invalid number of fields, received: " + fieldsCount);
                }
                dataMap = new HashMap<String, String>(fieldsCount);
                for (count = 0; count < fieldsCount; ++count) {
                    fieldLength = (int)in.readUnsignedInt();
                    fieldBuf = in.readBytes(fieldLength);
                    field = fieldBuf.toString(Charset.forName("UTF8"));
                    fieldBuf.release();
                    dataLength = (int)in.readUnsignedInt();
                    dataBuf = in.readBytes(dataLength);
                    data = dataBuf.toString(Charset.forName("UTF8"));
                    dataBuf.release();
                    dataMap.put(field, data);
                }
                message = new Message(this.sequence, dataMap);
                ((V1Batch)this.batch).addMessage(message);
                if (this.batch.isComplete()) {
                    out.add(this.batch);
                    this.batchComplete();
                }
                this.transition(States.READ_HEADER);
                break;
            }
            case 5: {
                BeatsParser.logger.trace("Running: READ_JSON_HEADER");
                this.sequence = (int)in.readUnsignedInt();
                jsonPayloadSize = (int)in.readUnsignedInt();
                if (jsonPayloadSize <= 0) {
                    throw new InvalidFrameProtocolException("Invalid json length, received: " + jsonPayloadSize);
                }
                this.transition(States.READ_JSON, jsonPayloadSize);
                break;
            }
            case 6: {
                BeatsParser.logger.trace("Running: READ_COMPRESSED_FRAME_HEADER");
                this.transition(States.READ_COMPRESSED_FRAME, in.readInt());
                break;
            }
            case 7: {
                BeatsParser.logger.trace("Running: READ_COMPRESSED_FRAME");
                buffer = ctx.alloc().buffer(this.requiredBytes);
                buffOutput = new ByteBufOutputStream(buffer);
                var6_12 = null;
                inflater = new InflaterOutputStream((OutputStream)buffOutput, new Inflater());
                var8_19 = null;
                try {
                    in.readBytes((OutputStream)inflater, this.requiredBytes);
                    this.transition(States.READ_HEADER);
                    try {
                        while (buffer.readableBytes() > 0) {
                            this.decode(ctx, buffer, out);
                        }
                    }
                    finally {
                        buffer.release();
                    }
                }
                catch (Throwable var9_22) {
                    var8_19 = var9_22;
                    throw var9_22;
                }
                finally {
                    if (inflater != null) {
                        if (var8_19 != null) {
                            try {
                                inflater.close();
                            }
                            catch (Throwable var9_21) {
                                var8_19.addSuppressed(var9_21);
                            }
                        } else {
                            inflater.close();
                        }
                    }
                }
                if (buffOutput == null) break;
                if (var6_12 == null) ** GOTO lbl126
                try {
                    buffOutput.close();
                }
                catch (Throwable var7_16) {
                    var6_12.addSuppressed(var7_16);
                }
                break;
lbl126:
                // 1 sources

                buffOutput.close();
                break;
                catch (Throwable var7_17) {
                    try {
                        var6_12 = var7_17;
                        throw var7_17;
                    }
                    catch (Throwable var16_29) {
                        if (buffOutput != null) {
                            if (var6_12 != null) {
                                try {
                                    buffOutput.close();
                                }
                                catch (Throwable var17_30) {
                                    var6_12.addSuppressed(var17_30);
                                }
                            } else {
                                buffOutput.close();
                            }
                        }
                        throw var16_29;
                    }
                }
            }
            case 8: {
                BeatsParser.logger.trace("Running: READ_JSON");
                ((V2Batch)this.batch).addMessage(this.sequence, in, this.requiredBytes);
                if (this.batch.isComplete()) {
                    if (BeatsParser.logger.isTraceEnabled()) {
                        BeatsParser.logger.trace("Sending batch size: " + this.batch.size() + ", windowSize: " + this.batch.getBatchSize() + " , seq: " + this.sequence);
                    }
                    out.add(this.batch);
                    this.batchComplete();
                }
                this.transition(States.READ_HEADER);
            }
        }
    }

    private boolean hasEnoughBytes(ByteBuf in) {
        return in.readableBytes() >= this.requiredBytes;
    }

    private void transition(States next) {
        this.transition(next, next.length);
    }

    private void transition(States nextState, int requiredBytes) {
        if (logger.isTraceEnabled()) {
            logger.trace("Transition, from: " + (Object)((Object)this.currentState) + ", to: " + (Object)((Object)nextState) + ", requiring " + requiredBytes + " bytes");
        }
        this.currentState = nextState;
        this.requiredBytes = requiredBytes;
    }

    private void batchComplete() {
        this.requiredBytes = 0;
        this.sequence = 0;
        this.batch = null;
    }

    public class InvalidFrameProtocolException
    extends Exception {
        InvalidFrameProtocolException(String message) {
            super(message);
        }
    }

    private static enum States {
        READ_HEADER(1),
        READ_FRAME_TYPE(1),
        READ_WINDOW_SIZE(4),
        READ_JSON_HEADER(8),
        READ_COMPRESSED_FRAME_HEADER(4),
        READ_COMPRESSED_FRAME(-1),
        READ_JSON(-1),
        READ_DATA_FIELDS(-1);

        private int length;

        private States(int length) {
            this.length = length;
        }
    }
}

