/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLHandshakeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.beats.Ack;
import org.logstash.beats.Batch;
import org.logstash.beats.ConnectionHandler;
import org.logstash.beats.IMessageListener;
import org.logstash.beats.Message;

public class BeatsHandler
extends SimpleChannelInboundHandler<Batch> {
    private static final Logger logger = LogManager.getLogger(BeatsHandler.class);
    private final IMessageListener messageListener;

    public BeatsHandler(IMessageListener listener) {
        this.messageListener = listener;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Channel Active");
        }
        super.channelActive(ctx);
        this.messageListener.onNewConnection(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (logger.isTraceEnabled()) {
            logger.trace("Channel Inactive");
        }
        this.messageListener.onConnectionClose(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext ctx, Batch batch) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Received a new payload");
        }
        try {
            for (Message message : batch) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending a new message for the listener, sequence: " + message.getSequence());
                }
                this.messageListener.onNewMessage(ctx, message);
                if (!this.needAck(message)) continue;
                this.ack(ctx, message);
            }
        }
        finally {
            ((AtomicBoolean)ctx.channel().attr(ConnectionHandler.CHANNEL_SEND_KEEP_ALIVE).get()).set(false);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: batches pending: {}", (Object)ctx.channel().id().asShortText(), (Object)((AtomicBoolean)ctx.channel().attr(ConnectionHandler.CHANNEL_SEND_KEEP_ALIVE).get()).get());
            }
            batch.release();
            ctx.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            String causeMessage;
            InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
            String string = causeMessage = cause.getMessage() == null ? cause.getClass().toString() : cause.getMessage();
            if (remoteAddress != null) {
                logger.info("Exception: " + causeMessage + ", from: " + remoteAddress.toString());
            } else {
                logger.info("Exception: " + causeMessage);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Exception: " + causeMessage, cause);
            }
            if (!(cause instanceof SSLHandshakeException)) {
                this.messageListener.onException(ctx, cause);
            }
        }
        finally {
            super.exceptionCaught(ctx, cause);
            ctx.flush();
            ctx.close();
        }
    }

    private boolean needAck(Message message) {
        return message.getSequence() == message.getBatch().getBatchSize();
    }

    private void ack(ChannelHandlerContext ctx, Message message) {
        this.writeAck(ctx, message.getBatch().getProtocol(), message.getSequence());
    }

    private void writeAck(ChannelHandlerContext ctx, byte protocol, int sequence) {
        ctx.write((Object)new Ack(protocol, sequence));
    }
}

