/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.ext.ripper.LexerSource;
import org.jruby.ext.ripper.RipperLexer;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.StringTerm;
import org.jruby.util.ByteList;

public class HeredocTerm
extends StrTerm {
    private final ByteList nd_lit;
    private final int flags;
    protected final int nth;
    protected final int line;
    protected final ByteList lastLine;

    public HeredocTerm(ByteList marker, int func, int nth, int line, ByteList lastLine) {
        this.nd_lit = marker;
        this.flags = func;
        this.nth = nth;
        this.line = line;
        this.lastLine = lastLine;
    }

    protected int error(RipperLexer lexer, int len, ByteList str, ByteList eos) {
        lexer.compile_error("can't find string \"" + eos.toString() + "\" anywhere before EOF");
        if (lexer.delayed == null) {
            lexer.dispatchScanEvent(377);
        } else {
            if (str != null) {
                lexer.delayed.append(str);
            } else {
                len = lexer.lex_p - lexer.tokp;
                if (len > 0) {
                    lexer.delayed.append(lexer.lexb.makeShared(lexer.tokp, len));
                }
            }
            lexer.dispatchDelayedToken(377);
        }
        lexer.lex_goto_eol();
        return this.restore(lexer);
    }

    protected int restore(RipperLexer lexer) {
        lexer.heredoc_restore(this);
        lexer.setStrTerm(null);
        return -1;
    }

    @Override
    public int parseString(RipperLexer lexer, LexerSource src) throws IOException {
        ByteList str = null;
        ByteList eos = this.nd_lit;
        int len = this.nd_lit.length() - 1;
        boolean indent = (this.flags & 0x20) != 0;
        int c = lexer.nextc();
        if (c == -1) {
            return this.error(lexer, len, str, eos);
        }
        if (lexer.was_bol() && lexer.whole_match_p(this.nd_lit, indent)) {
            lexer.dispatchHeredocEnd();
            lexer.heredoc_restore(this);
            return 372;
        }
        if ((this.flags & 2) == 0) {
            do {
                ByteList lbuf = lexer.lex_lastline;
                int pend = lexer.lex_pend;
                int p = 0;
                if (pend > p) {
                    switch (lexer.p(pend - 1)) {
                        case 10: {
                            if (--pend == p || lexer.p(pend - 1) == 13) {
                                ++pend;
                                break;
                            }
                        }
                        case 13: {
                            --pend;
                        }
                    }
                }
                if (str != null) {
                    str.append(lbuf.makeShared(p, pend - p));
                } else {
                    str = new ByteList(lbuf.makeShared(p, pend - p));
                }
                if (pend < lexer.lex_pend) {
                    str.append(10);
                }
                lexer.lex_goto_eol();
                if (lexer.nextc() != -1 || str == null) continue;
                return this.error(lexer, len, str, eos);
            } while (!lexer.whole_match_p(eos, indent));
        } else {
            ByteList tok = new ByteList();
            tok.setEncoding(lexer.getEncoding());
            if (c == 35) {
                c = lexer.nextc();
                switch (c) {
                    case 36: 
                    case 64: {
                        lexer.pushback(c);
                        return 371;
                    }
                    case 123: {
                        lexer.commandStart = true;
                        return 370;
                    }
                }
                tok.append(35);
            }
            do {
                lexer.pushback(c);
                Encoding[] enc = new Encoding[]{lexer.getEncoding()};
                c = new StringTerm(this.flags, 0, 10).parseStringIntoBuffer(lexer, src, tok, enc);
                if (c == -1) {
                    if (lexer.eofp) {
                        return this.error(lexer, len, str, eos);
                    }
                    return this.restore(lexer);
                }
                if (c != 10) {
                    lexer.setValue(lexer.createStr(tok, 0));
                    lexer.flush_string_content(enc[0]);
                    return 377;
                }
                tok.append(lexer.nextc());
                c = lexer.nextc();
                if (c != -1) continue;
                return this.error(lexer, len, str, eos);
            } while (!lexer.whole_match_p(eos, indent));
            str = tok;
        }
        lexer.dispatchHeredocEnd();
        lexer.heredoc_restore(this);
        lexer.setStrTerm(new StringTerm(-1, 0, 0));
        lexer.setValue(lexer.createStr(str, 0));
        return 377;
    }
}

