/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.Iterator;
import org.logstash.beats.Batch;
import org.logstash.beats.Message;

public class V2Batch
implements Batch {
    private ByteBuf internalBuffer = PooledByteBufAllocator.DEFAULT.buffer();
    private int written = 0;
    private int read = 0;
    private static final int SIZE_OF_INT = 4;
    private int batchSize;

    public void setProtocol(byte protocol) {
        if (protocol != 50) {
            throw new IllegalArgumentException("Only version 2 protocol is supported");
        }
    }

    @Override
    public byte getProtocol() {
        return 50;
    }

    @Override
    public Iterator<Message> iterator() {
        this.internalBuffer.resetReaderIndex();
        return new Iterator<Message>(){

            @Override
            public boolean hasNext() {
                return V2Batch.this.read < V2Batch.this.written;
            }

            @Override
            public Message next() {
                int sequenceNumber = V2Batch.this.internalBuffer.readInt();
                int readableBytes = V2Batch.this.internalBuffer.readInt();
                Message message = new Message(sequenceNumber, V2Batch.this.internalBuffer.slice(V2Batch.this.internalBuffer.readerIndex(), readableBytes));
                V2Batch.this.internalBuffer.readerIndex(V2Batch.this.internalBuffer.readerIndex() + readableBytes);
                message.setBatch(V2Batch.this);
                V2Batch.this.read++;
                return message;
            }
        };
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int size() {
        return this.written;
    }

    @Override
    public boolean isEmpty() {
        return this.written == 0;
    }

    @Override
    public boolean isComplete() {
        return this.written == this.batchSize;
    }

    void addMessage(int sequenceNumber, ByteBuf buffer, int size) {
        ++this.written;
        if (this.internalBuffer.writableBytes() < size + 8) {
            this.internalBuffer.capacity(this.internalBuffer.capacity() + size + 8);
        }
        this.internalBuffer.writeInt(sequenceNumber);
        this.internalBuffer.writeInt(size);
        buffer.readBytes(this.internalBuffer, size);
    }

    @Override
    public void release() {
        this.internalBuffer.release();
    }
}

