/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.beats.AckEncoder;
import org.logstash.beats.BeatsHandler;
import org.logstash.beats.BeatsParser;
import org.logstash.beats.ConnectionHandler;
import org.logstash.beats.IMessageListener;
import org.logstash.beats.MessageListener;
import org.logstash.netty.SslSimpleBuilder;

public class Server {
    private static final Logger logger = LogManager.getLogger(Server.class);
    private final int port;
    private final NioEventLoopGroup workGroup;
    private final String host;
    private final int beatsHeandlerThreadCount;
    private IMessageListener messageListener = new MessageListener();
    private SslSimpleBuilder sslBuilder;
    private BeatsInitializer beatsInitializer;
    private final int clientInactivityTimeoutSeconds;

    public Server(String host, int p, int timeout, int threadCount) {
        this.host = host;
        this.port = p;
        this.clientInactivityTimeoutSeconds = timeout;
        this.beatsHeandlerThreadCount = threadCount;
        this.workGroup = new NioEventLoopGroup();
    }

    public void enableSSL(SslSimpleBuilder builder) {
        this.sslBuilder = builder;
    }

    public Server listen() throws InterruptedException {
        try {
            logger.info("Starting server on port: " + this.port);
            this.beatsInitializer = new BeatsInitializer(this.isSslEnable(), this.messageListener, this.clientInactivityTimeoutSeconds, this.beatsHeandlerThreadCount);
            ServerBootstrap server = new ServerBootstrap();
            ((ServerBootstrap)server.group((EventLoopGroup)this.workGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.SO_LINGER, (Object)0).childHandler((ChannelHandler)this.beatsInitializer);
            Channel channel = server.bind(this.host, this.port).sync().channel();
            channel.closeFuture().sync();
        }
        finally {
            this.shutdown();
        }
        return this;
    }

    public void stop() throws InterruptedException {
        logger.debug("Server shutting down");
        this.shutdown();
        logger.debug("Server stopped");
    }

    private void shutdown() {
        try {
            this.workGroup.shutdownGracefully().sync();
            this.beatsInitializer.shutdownEventExecutor();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setMessageListener(IMessageListener listener) {
        this.messageListener = listener;
    }

    public boolean isSslEnable() {
        return this.sslBuilder != null;
    }

    private class BeatsInitializer
    extends ChannelInitializer<SocketChannel> {
        private final String LOGGER_HANDLER = "logger";
        private final String SSL_HANDLER = "ssl-handler";
        private final String IDLESTATE_HANDLER = "idlestate-handler";
        private final String CONNECTION_HANDLER = "connection-handler";
        private final String BEATS_ACKER = "beats-acker";
        private final int DEFAULT_IDLESTATEHANDLER_THREAD = 4;
        private final int IDLESTATE_WRITER_IDLE_TIME_SECONDS = 5;
        private final EventExecutorGroup idleExecutorGroup;
        private final EventExecutorGroup beatsHandlerExecutorGroup;
        private final IMessageListener message;
        private int clientInactivityTimeoutSeconds;
        private final LoggingHandler loggingHandler = new LoggingHandler();
        private boolean enableSSL = false;

        public BeatsInitializer(Boolean secure, IMessageListener messageListener, int clientInactivityTimeoutSeconds, int beatsHandlerThread) {
            this.enableSSL = secure;
            this.message = messageListener;
            this.clientInactivityTimeoutSeconds = clientInactivityTimeoutSeconds;
            this.idleExecutorGroup = new DefaultEventExecutorGroup(4);
            this.beatsHandlerExecutorGroup = new DefaultEventExecutorGroup(beatsHandlerThread);
        }

        public void initChannel(SocketChannel socket) throws IOException, NoSuchAlgorithmException, CertificateException {
            ChannelPipeline pipeline = socket.pipeline();
            pipeline.addLast("logger", (ChannelHandler)this.loggingHandler);
            if (this.enableSSL) {
                SslHandler sslHandler = Server.this.sslBuilder.build(socket.alloc());
                pipeline.addLast("ssl-handler", (ChannelHandler)sslHandler);
            }
            pipeline.addLast(this.idleExecutorGroup, "idlestate-handler", (ChannelHandler)new IdleStateHandler(this.clientInactivityTimeoutSeconds, 5, this.clientInactivityTimeoutSeconds));
            pipeline.addLast("beats-acker", (ChannelHandler)new AckEncoder());
            pipeline.addLast("connection-handler", (ChannelHandler)new ConnectionHandler());
            pipeline.addLast(this.beatsHandlerExecutorGroup, new ChannelHandler[]{new BeatsParser(), new BeatsHandler(this.message)});
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.warn("Exception caught in channel initializer", cause);
            try {
                this.message.onChannelInitializeException(ctx, cause);
            }
            finally {
                super.exceptionCaught(ctx, cause);
            }
        }

        public void shutdownEventExecutor() {
            try {
                this.idleExecutorGroup.shutdownGracefully().sync();
                this.beatsHandlerExecutorGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

