/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Map;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.Config;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.HMAC;
import org.jruby.ext.openssl.NetscapeSPKI;
import org.jruby.ext.openssl.PKCS5;
import org.jruby.ext.openssl.PKCS7;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Random;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.X509;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;

@JRubyModule(name={"OpenSSL"})
public final class OpenSSL {
    private static boolean debug;
    private static boolean warn;
    private static boolean tryContextSecureRandom;

    public static void load(Ruby runtime) {
        OpenSSL.createOpenSSL(runtime);
    }

    public static boolean isProviderAvailable() {
        return SecurityHelper.isProviderAvailable("BC");
    }

    public static void createOpenSSL(Ruby runtime) {
        boolean ruby18;
        SecurityHelper.setRegisterProvider(SafePropertyAccessor.getBoolean((String)"jruby.openssl.provider.register"));
        RubyModule _OpenSSL = runtime.getOrCreateModule("OpenSSL");
        RubyClass _StandardError = runtime.getClass("StandardError");
        _OpenSSL.defineClassUnder("OpenSSLError", _StandardError, _StandardError.getAllocator());
        _OpenSSL.defineAnnotatedMethods(OpenSSL.class);
        OpenSSL.setDebug((IRubyObject)_OpenSSL, (IRubyObject)runtime.newBoolean(SafePropertyAccessor.getBoolean((String)"jruby.openssl.debug")));
        String warn = SafePropertyAccessor.getProperty((String)"jruby.openssl.warn");
        if (warn != null) {
            OpenSSL.warn = Boolean.parseBoolean(warn);
        }
        PKey.createPKey(runtime, _OpenSSL);
        BN.createBN(runtime, _OpenSSL);
        Digest.createDigest(runtime, _OpenSSL);
        Cipher.createCipher(runtime, _OpenSSL);
        Random.createRandom(runtime, _OpenSSL);
        HMAC.createHMAC(runtime, _OpenSSL);
        Config.createConfig(runtime, _OpenSSL);
        ASN1.createASN1(runtime, _OpenSSL);
        X509.createX509(runtime, _OpenSSL);
        NetscapeSPKI.createNetscapeSPKI(runtime, _OpenSSL);
        SSL.createSSL(runtime, _OpenSSL);
        PKCS7.createPKCS7(runtime, _OpenSSL);
        PKCS5.createPKCS5(runtime, _OpenSSL);
        runtime.getLoadService().require("jopenssl/version");
        byte[] version2 = new byte[]{49, 46, 49, 46, 48};
        boolean bl = ruby18 = runtime.getInstanceConfig().getCompatVersion() == CompatVersion.RUBY1_8;
        if (ruby18) {
            version2[2] = 48;
        }
        _OpenSSL.setConstant("VERSION", (IRubyObject)StringHelper.newString(runtime, version2));
        RubyModule _Jopenssl = runtime.getModule("Jopenssl");
        RubyModule _Version = (RubyModule)_Jopenssl.getConstantAt("Version");
        RubyString jVERSION = _Version.getConstantAt("VERSION").asString();
        byte[] JRuby_OpenSSL_ = new byte[]{74, 82, 117, 98, 121, 45, 79, 112, 101, 110, 83, 83, 76, 32};
        int OPENSSL_VERSION_NUMBER = 999999999;
        ByteList OPENSSL_VERSION = new ByteList(jVERSION.getByteList().length() + JRuby_OpenSSL_.length);
        OPENSSL_VERSION.setEncoding(jVERSION.getEncoding());
        OPENSSL_VERSION.append(JRuby_OpenSSL_);
        OPENSSL_VERSION.append(jVERSION.getByteList());
        RubyString VERSION = runtime.newString(OPENSSL_VERSION);
        _OpenSSL.setConstant("OPENSSL_VERSION", (IRubyObject)VERSION);
        _OpenSSL.setConstant("OPENSSL_VERSION_NUMBER", (IRubyObject)runtime.newFixnum(999999999));
        if (!ruby18) {
            _OpenSSL.setConstant("OPENSSL_LIBRARY_VERSION", (IRubyObject)VERSION);
            _OpenSSL.setConstant("OPENSSL_FIPS", (IRubyObject)runtime.getFalse());
        }
    }

    static RubyClass _OpenSSLError(Ruby runtime) {
        return runtime.getModule("OpenSSL").getClass("OpenSSLError");
    }

    @JRubyMethod(name={"errors"}, meta=true)
    public static IRubyObject errors(IRubyObject self) {
        Ruby runtime = self.getRuntime();
        RubyArray result = runtime.newArray();
        for (Map.Entry<Integer, String> e : X509.getErrors().entrySet()) {
            result.add((Object)runtime.newString(e.getValue()));
        }
        return result;
    }

    @JRubyMethod(name={"debug"}, meta=true)
    public static IRubyObject getDebug(IRubyObject self) {
        return (IRubyObject)OpenSSL.getDebug((RubyModule)self);
    }

    private static Object getDebug(RubyModule self) {
        return self.getInternalVariable("debug");
    }

    @JRubyMethod(name={"debug="}, meta=true)
    public static IRubyObject setDebug(IRubyObject self, IRubyObject debug) {
        ((RubyModule)self).setInternalVariable("debug", (Object)debug);
        OpenSSL.debug = debug.isTrue();
        return debug;
    }

    @JRubyMethod(name={"Digest"}, meta=true)
    public static IRubyObject Digest(IRubyObject self, IRubyObject name2) {
        Ruby runtime = self.getRuntime();
        RubyClass Digest2 = runtime.getModule("OpenSSL").getClass("Digest");
        return Digest2.getConstantAt(name2.asString().toString());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject deprecated_warning_flag(IRubyObject self) {
        return self.getRuntime().getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject check_func(IRubyObject self, IRubyObject[] args) {
        return self.getRuntime().getNil();
    }

    @JRubyMethod(name={"fips_mode="}, meta=true)
    public static IRubyObject set_fips_mode(ThreadContext context2, IRubyObject self, IRubyObject value2) {
        if (value2.isTrue()) {
            OpenSSL.warn(context2, "WARNING: FIPS mode not supported on JRuby-OpenSSL");
        }
        return value2;
    }

    static boolean isDebug() {
        return debug;
    }

    static void debugStackTrace(Throwable e) {
        if (OpenSSL.isDebug()) {
            e.printStackTrace(System.out);
        }
    }

    static void debug(String msg) {
        if (OpenSSL.isDebug()) {
            System.out.println(msg);
        }
    }

    static void debug(String msg, Throwable e) {
        if (OpenSSL.isDebug()) {
            System.out.println(msg + ' ' + e);
        }
    }

    static boolean isDebug(Ruby runtime) {
        RubyModule OpenSSL2 = runtime.getModule("OpenSSL");
        if (OpenSSL2 == null) {
            return debug;
        }
        return OpenSSL.getDebug(OpenSSL2) == runtime.getTrue();
    }

    static void debugStackTrace(Ruby runtime, Throwable e) {
        if (OpenSSL.isDebug(runtime)) {
            e.printStackTrace(runtime.getOut());
        }
    }

    public static void debug(Ruby runtime, CharSequence msg) {
        if (OpenSSL.isDebug(runtime)) {
            runtime.getOut().println(msg.toString());
        }
    }

    public static void debug(Ruby runtime, CharSequence msg, Throwable e) {
        if (OpenSSL.isDebug(runtime)) {
            runtime.getOut().println(msg.toString() + ' ' + e);
        }
    }

    static void warn(ThreadContext context2, CharSequence msg) {
        OpenSSL.warn(context2, RubyString.newString((Ruby)context2.runtime, (CharSequence)msg));
    }

    static void warn(ThreadContext context2, RubyString msg) {
        OpenSSL.warn(context2, (IRubyObject)msg);
    }

    static void warn(ThreadContext context2, IRubyObject msg) {
        if (warn) {
            context2.runtime.getModule("OpenSSL").callMethod(context2, "warn", msg);
        }
    }

    private static String javaVersion(String def) {
        String javaVersionProperty = SafePropertyAccessor.getProperty((String)"java.version", (String)def);
        if (javaVersionProperty == "0") {
            return "1.7.0";
        }
        return javaVersionProperty;
    }

    static boolean javaVersion7(boolean atLeast) {
        int gt = "1.7".compareTo(OpenSSL.javaVersion("0.0").substring(0, 3));
        return atLeast ? gt <= 0 : gt == 0;
    }

    static boolean javaVersion8(boolean atLeast) {
        int gt = "1.8".compareTo(OpenSSL.javaVersion("0.0").substring(0, 3));
        return atLeast ? gt <= 0 : gt == 0;
    }

    private static String javaName(String def) {
        return SafePropertyAccessor.getProperty((String)"java.vm.name", (String)def);
    }

    static boolean javaHotSpot() {
        return OpenSSL.javaName("").contains("HotSpot(TM)");
    }

    static boolean javaOpenJDK() {
        return OpenSSL.javaName("").contains("OpenJDK");
    }

    static SecureRandom getSecureRandom(Ruby runtime) {
        return OpenSSL.getSecureRandom(runtime, false);
    }

    static SecureRandom getSecureRandom(Ruby runtime, boolean nullByDefault) {
        SecureRandom random;
        if (tryContextSecureRandom && (random = OpenSSL.getSecureRandomFrom(runtime.getCurrentContext())) != null) {
            return random;
        }
        return nullByDefault ? null : new SecureRandom();
    }

    static SecureRandom getSecureRandomFrom(ThreadContext context2) {
        if (tryContextSecureRandom) {
            try {
                SecureRandom random = context2.secureRandom;
                if (random == null) {
                    random = (SecureRandom)context2.getClass().getMethod("getSecureRandom", new Class[0]).invoke((Object)context2, new Object[0]);
                }
                return random;
            }
            catch (Throwable ex) {
                tryContextSecureRandom = false;
                OpenSSL.debug(context2.runtime, "JRuby-OpenSSL failed to retrieve secure random from thread-context", ex);
            }
        }
        return null;
    }

    static IRubyObject to_der_if_possible(ThreadContext context2, IRubyObject obj) {
        if (!obj.respondsTo("to_der")) {
            return obj;
        }
        return obj.callMethod(context2, "to_der");
    }

    static String bcExceptionMessage(NoSuchProviderException ex) {
        return "You need to configure JVM/classpath to enable BouncyCastle Security Provider: " + ex;
    }

    static String bcExceptionMessage(NoClassDefFoundError ex) {
        return "You need to configure JVM/classpath to enable BouncyCastle Security Provider: " + ex;
    }

    static {
        warn = true;
        tryContextSecureRandom = true;
    }
}

