/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common.io;

import java.io.IOException;
import java.io.OutputStream;

public abstract class StreamOutput
extends OutputStream {
    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    public abstract void writeByte(byte var1) throws IOException;

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public abstract void reset() throws IOException;

    public void writeVInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeShort(short i) throws IOException {
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)i);
    }

    public void writeInt(int i) throws IOException {
        this.writeByte((byte)(i >> 24));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)i);
    }

    public void writeIntArray(int[] values) throws IOException {
        this.writeVInt(values.length);
        for (int value : values) {
            this.writeInt(value);
        }
    }

    public void writeLong(long i) throws IOException {
        this.writeInt((int)(i >> 32));
        this.writeInt((int)i);
    }

    public void writeByteArray(byte[] b) throws IOException {
        this.writeInt(b.length);
        this.writeBytes(b, 0, b.length);
    }
}

