/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common.io;

import java.io.IOException;
import java.io.InputStream;

public abstract class StreamInput
extends InputStream {
    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        assert ((b & 0x80) == 0);
        return i | (b & 0x7F) << 28;
    }

    public short readShort() throws IOException {
        int i = (this.readByte() & 0xFF) << 8;
        int j = this.readByte() & 0xFF;
        return (short)(i | j);
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readInt();
        byte[] values = new byte[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readByte();
        }
        return values;
    }
}

