/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.DLQEntry;
import org.logstash.Timestamp;
import org.logstash.common.io.DeadLetterQueueWriter;
import org.logstash.common.io.RecordIOReader;

public final class DeadLetterQueueReader
implements Closeable {
    private static final Logger logger = LogManager.getLogger(DeadLetterQueueReader.class);
    private RecordIOReader currentReader;
    private final Path queuePath;
    private final ConcurrentSkipListSet<Path> segments;
    private final WatchService watchService;

    public DeadLetterQueueReader(Path queuePath) throws IOException {
        this.queuePath = queuePath;
        this.watchService = FileSystems.getDefault().newWatchService();
        this.queuePath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        this.segments = new ConcurrentSkipListSet((p1, p2) -> {
            Function<Path, Integer> id = p -> Integer.parseInt(p.getFileName().toString().split("\\.")[0]);
            return id.apply((Path)p1).compareTo(id.apply((Path)p2));
        });
        this.segments.addAll(DeadLetterQueueWriter.getSegmentPaths(queuePath).collect(Collectors.toList()));
    }

    public void seekToNextEvent(Timestamp timestamp) throws IOException {
        for (Path segment : this.segments) {
            this.currentReader = new RecordIOReader(segment);
            byte[] event = this.currentReader.seekToNextEventPosition(timestamp, b -> {
                try {
                    return DLQEntry.deserialize(b).getEntryTime();
                }
                catch (IOException e) {
                    return null;
                }
            }, Timestamp::compareTo);
            if (event == null) continue;
            return;
        }
        this.currentReader.close();
        this.currentReader = null;
    }

    private long pollNewSegments(long timeout) throws IOException, InterruptedException {
        long startTime = System.currentTimeMillis();
        WatchKey key = this.watchService.poll(timeout, TimeUnit.MILLISECONDS);
        if (key != null) {
            for (WatchEvent<?> watchEvent : key.pollEvents()) {
                if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                    this.segments.addAll(DeadLetterQueueWriter.getSegmentPaths(this.queuePath).collect(Collectors.toList()));
                }
                key.reset();
            }
        }
        return System.currentTimeMillis() - startTime;
    }

    public DLQEntry pollEntry(long timeout) throws IOException, InterruptedException {
        byte[] bytes = this.pollEntryBytes(timeout);
        if (bytes == null) {
            return null;
        }
        return DLQEntry.deserialize(bytes);
    }

    byte[] pollEntryBytes() throws IOException, InterruptedException {
        return this.pollEntryBytes(100L);
    }

    byte[] pollEntryBytes(long timeout) throws IOException, InterruptedException {
        byte[] event;
        long timeoutRemaining = timeout;
        if (this.currentReader == null) {
            timeoutRemaining -= this.pollNewSegments(timeout);
            if (this.segments.isEmpty()) {
                logger.debug("No entries found: no segment files found in dead-letter-queue directory");
                return null;
            }
            this.currentReader = new RecordIOReader(this.segments.first());
        }
        if ((event = this.currentReader.readEvent()) == null && this.currentReader.isEndOfStream()) {
            if (this.currentReader.getPath().equals(this.segments.last())) {
                this.pollNewSegments(timeoutRemaining);
            } else {
                this.currentReader.close();
                this.currentReader = new RecordIOReader(this.segments.higher(this.currentReader.getPath()));
                return this.pollEntryBytes(timeoutRemaining);
            }
        }
        return event;
    }

    public void setCurrentReaderAndPosition(Path segmentPath, long position) throws IOException {
        if (Files.exists(segmentPath, new LinkOption[0])) {
            this.currentReader = new RecordIOReader(segmentPath);
            this.currentReader.seekToOffset(position);
        } else {
            Path next = this.segments.higher(segmentPath);
            if (next != null) {
                this.currentReader = new RecordIOReader(next);
            }
        }
    }

    public Path getCurrentSegment() {
        return this.currentReader.getPath();
    }

    public long getCurrentPosition() {
        return this.currentReader.getChannelPosition();
    }

    @Override
    public void close() throws IOException {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
    }
}

