/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common.io;

import java.nio.ByteBuffer;
import org.logstash.common.io.StreamOutput;

public class ByteArrayStreamOutput
extends StreamOutput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayStreamOutput(byte[] bytes) {
        this.reset(bytes);
    }

    public ByteArrayStreamOutput(ByteBuffer bytebuffer) {
        this.reset(bytebuffer.array());
    }

    public ByteArrayStreamOutput(ByteBuffer bytebuffer, int offset, int len) {
        this.reset(bytebuffer.array(), offset, len);
    }

    public ByteArrayStreamOutput(byte[] bytes, int offset, int len) {
        this.reset(bytes, offset, len);
    }

    public void reset(byte[] bytes) {
        this.reset(bytes, 0, bytes.length);
    }

    public void reset(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.pos = offset;
        this.limit = offset + len;
    }

    public void setWriteWindow(int offset, int len) {
        this.pos = offset;
        this.limit = offset + len;
    }

    @Override
    public void reset() {
    }

    public void reset(int offset) {
        this.pos = offset;
    }

    public int getPosition() {
        return this.pos;
    }

    @Override
    public void writeByte(byte b) {
        assert (this.pos < this.limit) : String.format("ByteArrayStreamOutput#writeByte pos=%d !< limit=%d", this.pos, this.limit);
        this.bytes[this.pos++] = b;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        assert (this.pos + length <= this.limit);
        System.arraycopy(b, offset, this.bytes, this.pos, length);
        this.pos += length;
    }
}

