/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FsUtil {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final Logger logger = LogManager.getLogger(FsUtil.class);

    private FsUtil() {
    }

    public static boolean hasFreeSpace(Path path, long size) throws IOException {
        HashSet<File> partitionRoots = new HashSet<File>(Arrays.asList(File.listRoots()));
        File location = path.toFile().getCanonicalFile();
        while (!partitionRoots.contains(location)) {
            if ((location = location.getParentFile()) != null) continue;
            throw new IllegalStateException(String.format("Unable to determine the partition that contains '%s'", path));
        }
        long freeSpace = location.getFreeSpace();
        if (freeSpace == 0L && IS_WINDOWS) {
            logger.warn("Cannot retrieve free space on " + location.toString() + ". This is probably a SUBST'ed drive.");
            return true;
        }
        return location.getFreeSpace() >= size;
    }
}

