/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.bivalues;

import java.io.ObjectStreamException;
import org.jruby.Ruby;
import org.jruby.RubyInteger;
import org.jruby.javasupport.JavaUtil;
import org.logstash.bivalues.BiValue;
import org.logstash.bivalues.BiValueCommon;

public class IntegerBiValue
extends BiValueCommon<RubyInteger, Integer>
implements BiValue<RubyInteger, Integer> {
    public IntegerBiValue(RubyInteger rubyValue) {
        this.rubyValue = rubyValue;
        this.javaValue = null;
    }

    public IntegerBiValue(int javaValue) {
        this.javaValue = javaValue;
        this.rubyValue = null;
    }

    private IntegerBiValue() {
    }

    @Override
    protected void addRuby(Ruby runtime) {
        this.rubyValue = (RubyInteger)JavaUtil.convertJavaToUsableRubyObject((Ruby)runtime, (Object)this.javaValue);
    }

    @Override
    protected void addJava() {
        long value = ((RubyInteger)this.rubyValue).getLongValue();
        if ((long)((int)value) != value) {
            throw new ArithmeticException("Integer overflow - Incorrect IntegerBiValue usage: BiValues should pick LongBiValue for RubyInteger");
        }
        this.javaValue = (int)value;
    }

    private Object writeReplace() throws ObjectStreamException {
        return IntegerBiValue.newProxy(this);
    }
}

