/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.logstash.Event;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.Batch;
import org.logstash.ackedqueue.Queue;
import org.logstash.ackedqueue.SettingsImpl;
import org.logstash.ackedqueue.ext.JrubyAckedBatchExtLibrary;
import org.logstash.ext.JrubyEventExtLibrary;

public class JrubyAckedQueueExtLibrary
implements Library {
    public void load(Ruby runtime, boolean wrap) throws IOException {
        RubyModule module = runtime.defineModule("LogStash");
        RubyClass clazz = runtime.defineClassUnder("AckedQueue", runtime.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass rubyClass) {
                return new RubyAckedQueue(runtime, rubyClass);
            }
        }, module);
        clazz.defineAnnotatedMethods(RubyAckedQueue.class);
    }

    @JRubyClass(name={"AckedQueue"}, parent="Object")
    public static class RubyAckedQueue
    extends RubyObject {
        private Queue queue;

        public RubyAckedQueue(Ruby runtime, RubyClass klass) {
            super(runtime, klass);
        }

        public Queue getQueue() {
            return this.queue;
        }

        @JRubyMethod(name={"initialize"}, optional=7)
        public IRubyObject ruby_initialize(ThreadContext context, IRubyObject[] args) {
            args = Arity.scanArgs((Ruby)context.runtime, (IRubyObject[])args, (int)7, (int)0);
            int capacity = RubyFixnum.num2int((IRubyObject)args[1]);
            int maxUnread = RubyFixnum.num2int((IRubyObject)args[2]);
            int checkpointMaxAcks = RubyFixnum.num2int((IRubyObject)args[3]);
            int checkpointMaxWrites = RubyFixnum.num2int((IRubyObject)args[4]);
            long queueMaxBytes = RubyFixnum.num2long((IRubyObject)args[6]);
            this.queue = new Queue(SettingsImpl.fileSettingsBuilder(args[0].asJavaString()).capacity(capacity).maxUnread(maxUnread).queueMaxBytes(queueMaxBytes).checkpointMaxAcks(checkpointMaxAcks).checkpointMaxWrites(checkpointMaxWrites).elementClass(Event.class).build());
            return context.nil;
        }

        @JRubyMethod(name={"max_unread_events"})
        public IRubyObject ruby_max_unread_events(ThreadContext context) {
            return context.runtime.newFixnum(this.queue.getMaxUnread());
        }

        @JRubyMethod(name={"max_size_in_bytes"})
        public IRubyObject ruby_max_size_in_bytes(ThreadContext context) {
            return context.runtime.newFixnum(this.queue.getMaxBytes());
        }

        @JRubyMethod(name={"page_capacity"})
        public IRubyObject ruby_page_capacity(ThreadContext context) {
            return context.runtime.newFixnum(this.queue.getPageCapacity());
        }

        @JRubyMethod(name={"dir_path"})
        public IRubyObject ruby_dir_path(ThreadContext context) {
            return context.runtime.newString(this.queue.getDirPath());
        }

        @JRubyMethod(name={"current_byte_size"})
        public IRubyObject ruby_current_byte_size(ThreadContext context) {
            return context.runtime.newFixnum(this.queue.getPersistedByteSize());
        }

        @JRubyMethod(name={"persisted_size_in_bytes"})
        public IRubyObject ruby_persisted_size_in_bytes(ThreadContext context) {
            return context.runtime.newFixnum(this.queue.getPersistedByteSize());
        }

        @JRubyMethod(name={"acked_count"})
        public IRubyObject ruby_acked_count(ThreadContext context) {
            return context.runtime.newFixnum(this.queue.getAckedCount());
        }

        @JRubyMethod(name={"unacked_count"})
        public IRubyObject ruby_unacked_count(ThreadContext context) {
            return context.runtime.newFixnum(this.queue.getUnackedCount());
        }

        @JRubyMethod(name={"unread_count"})
        public IRubyObject ruby_unread_count(ThreadContext context) {
            return context.runtime.newFixnum(this.queue.getUnreadCount());
        }

        @JRubyMethod(name={"open"})
        public IRubyObject ruby_open(ThreadContext context) {
            try {
                this.queue.open();
            }
            catch (IOException e) {
                throw RubyUtil.newRubyIOError(context.runtime, e);
            }
            return context.nil;
        }

        @JRubyMethod(name={"write", "<<"}, required=1)
        public IRubyObject ruby_write(ThreadContext context, IRubyObject event) {
            long seqNum;
            if (!(event instanceof JrubyEventExtLibrary.RubyEvent)) {
                throw context.runtime.newTypeError("wrong argument type " + event.getMetaClass() + " (expected LogStash::Event)");
            }
            try {
                seqNum = this.queue.write(((JrubyEventExtLibrary.RubyEvent)event).getEvent());
            }
            catch (IOException e) {
                throw RubyUtil.newRubyIOError(context.runtime, e);
            }
            return context.runtime.newFixnum(seqNum);
        }

        @JRubyMethod(name={"read_batch"}, required=2)
        public IRubyObject ruby_read_batch(ThreadContext context, IRubyObject limit, IRubyObject timeout) {
            Batch b;
            try {
                b = this.queue.readBatch(RubyFixnum.num2int((IRubyObject)limit), RubyFixnum.num2int((IRubyObject)timeout));
            }
            catch (IOException e) {
                throw RubyUtil.newRubyIOError(context.runtime, e);
            }
            return b == null ? context.nil : new JrubyAckedBatchExtLibrary.RubyAckedBatch(context.runtime, b);
        }

        @JRubyMethod(name={"is_fully_acked?"})
        public IRubyObject ruby_is_fully_acked(ThreadContext context) {
            return RubyBoolean.newBoolean((Ruby)context.runtime, (boolean)this.queue.isFullyAcked());
        }

        @JRubyMethod(name={"is_empty?"})
        public IRubyObject ruby_is_empty(ThreadContext context) {
            return RubyBoolean.newBoolean((Ruby)context.runtime, (boolean)this.queue.isEmpty());
        }

        @JRubyMethod(name={"close"})
        public IRubyObject ruby_close(ThreadContext context) {
            try {
                this.queue.close();
            }
            catch (IOException e) {
                throw RubyUtil.newRubyIOError(context.runtime, e);
            }
            return context.nil;
        }
    }
}

