/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import org.logstash.ackedqueue.Queueable;
import org.logstash.ackedqueue.Settings;

public class SettingsImpl
implements Settings {
    private String dirForFiles;
    private Class<? extends Queueable> elementClass;
    private int capacity;
    private long queueMaxBytes;
    private int maxUnread;
    private int checkpointMaxAcks;
    private int checkpointMaxWrites;

    public static Settings.Builder builder(Settings settings) {
        return new BuilderImpl(settings.getDirPath(), settings.getElementClass(), settings.getCapacity(), settings.getQueueMaxBytes(), settings.getMaxUnread(), settings.getCheckpointMaxAcks(), settings.getCheckpointMaxWrites());
    }

    public static Settings.Builder fileSettingsBuilder(String dirForFiles) {
        return new BuilderImpl(dirForFiles);
    }

    private SettingsImpl(String dirForFiles, Class<? extends Queueable> elementClass, int capacity, long queueMaxBytes, int maxUnread, int checkpointMaxAcks, int checkpointMaxWrites) {
        this.dirForFiles = dirForFiles;
        this.elementClass = elementClass;
        this.capacity = capacity;
        this.queueMaxBytes = queueMaxBytes;
        this.maxUnread = maxUnread;
        this.checkpointMaxAcks = checkpointMaxAcks;
        this.checkpointMaxWrites = checkpointMaxWrites;
    }

    @Override
    public int getCheckpointMaxAcks() {
        return this.checkpointMaxAcks;
    }

    @Override
    public int getCheckpointMaxWrites() {
        return this.checkpointMaxWrites;
    }

    @Override
    public Class<? extends Queueable> getElementClass() {
        return this.elementClass;
    }

    @Override
    public String getDirPath() {
        return this.dirForFiles;
    }

    @Override
    public long getQueueMaxBytes() {
        return this.queueMaxBytes;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getMaxUnread() {
        return this.maxUnread;
    }

    private static final class BuilderImpl
    implements Settings.Builder {
        private static final int DEFAULT_CAPACITY = 0;
        private static final long DEFAULT_MAX_QUEUE_BYTES = 0L;
        private static final int DEFAULT_MAX_UNREAD = 0;
        private static final int DEFAULT_CHECKPOINT_MAX_ACKS = 1024;
        private static final int DEFAULT_CHECKPOINT_MAX_WRITES = 1024;
        private final String dirForFiles;
        private final Class<? extends Queueable> elementClass;
        private final int capacity;
        private final long queueMaxBytes;
        private final int maxUnread;
        private final int checkpointMaxAcks;
        private final int checkpointMaxWrites;

        private BuilderImpl(String dirForFiles) {
            this(dirForFiles, null, 0, 0L, 0, 1024, 1024);
        }

        private BuilderImpl(String dirForFiles, Class<? extends Queueable> elementClass, int capacity, long queueMaxBytes, int maxUnread, int checkpointMaxAcks, int checkpointMaxWrites) {
            this.dirForFiles = dirForFiles;
            this.elementClass = elementClass;
            this.capacity = capacity;
            this.queueMaxBytes = queueMaxBytes;
            this.maxUnread = maxUnread;
            this.checkpointMaxAcks = checkpointMaxAcks;
            this.checkpointMaxWrites = checkpointMaxWrites;
        }

        @Override
        public Settings.Builder elementClass(Class<? extends Queueable> elementClass) {
            return new BuilderImpl(this.dirForFiles, elementClass, this.capacity, this.queueMaxBytes, this.maxUnread, this.checkpointMaxAcks, this.checkpointMaxWrites);
        }

        @Override
        public Settings.Builder capacity(int capacity) {
            return new BuilderImpl(this.dirForFiles, this.elementClass, capacity, this.queueMaxBytes, this.maxUnread, this.checkpointMaxAcks, this.checkpointMaxWrites);
        }

        @Override
        public Settings.Builder queueMaxBytes(long size) {
            return new BuilderImpl(this.dirForFiles, this.elementClass, this.capacity, size, this.maxUnread, this.checkpointMaxAcks, this.checkpointMaxWrites);
        }

        @Override
        public Settings.Builder maxUnread(int maxUnread) {
            return new BuilderImpl(this.dirForFiles, this.elementClass, this.capacity, this.queueMaxBytes, maxUnread, this.checkpointMaxAcks, this.checkpointMaxWrites);
        }

        @Override
        public Settings.Builder checkpointMaxAcks(int checkpointMaxAcks) {
            return new BuilderImpl(this.dirForFiles, this.elementClass, this.capacity, this.queueMaxBytes, this.maxUnread, checkpointMaxAcks, this.checkpointMaxWrites);
        }

        @Override
        public Settings.Builder checkpointMaxWrites(int checkpointMaxWrites) {
            return new BuilderImpl(this.dirForFiles, this.elementClass, this.capacity, this.queueMaxBytes, this.maxUnread, this.checkpointMaxAcks, checkpointMaxWrites);
        }

        @Override
        public Settings build() {
            return new SettingsImpl(this.dirForFiles, this.elementClass, this.capacity, this.queueMaxBytes, this.maxUnread, this.checkpointMaxAcks, this.checkpointMaxWrites);
        }
    }
}

