/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.IOException;
import java.util.BitSet;
import org.logstash.ackedqueue.Checkpoint;
import org.logstash.ackedqueue.Queue;
import org.logstash.ackedqueue.SequencedList;
import org.logstash.ackedqueue.io.CheckpointIO;
import org.logstash.ackedqueue.io.PageIO;

public final class Page
implements Closeable {
    protected final int pageNum;
    protected long minSeqNum;
    protected int elementCount;
    protected long firstUnreadSeqNum;
    protected final Queue queue;
    protected PageIO pageIO;
    private boolean writable;
    protected BitSet ackedSeqNums;
    protected Checkpoint lastCheckpoint;

    public Page(int pageNum, Queue queue, long minSeqNum, int elementCount, long firstUnreadSeqNum, BitSet ackedSeqNums, PageIO pageIO, boolean writable) {
        this.pageNum = pageNum;
        this.queue = queue;
        this.minSeqNum = minSeqNum;
        this.elementCount = elementCount;
        this.firstUnreadSeqNum = firstUnreadSeqNum;
        this.ackedSeqNums = ackedSeqNums;
        this.lastCheckpoint = new Checkpoint(0, 0, 0L, 0L, 0);
        this.pageIO = pageIO;
        this.writable = writable;
        assert (this.pageIO != null) : "invalid null pageIO";
    }

    public String toString() {
        return "pageNum=" + this.pageNum + ", minSeqNum=" + this.minSeqNum + ", elementCount=" + this.elementCount + ", firstUnreadSeqNum=" + this.firstUnreadSeqNum;
    }

    public SequencedList<byte[]> read(int limit) throws IOException {
        this.pageIO.activate();
        SequencedList<byte[]> serialized = this.pageIO.read(this.firstUnreadSeqNum, limit);
        assert (serialized.getSeqNums().get(0) == this.firstUnreadSeqNum) : String.format("firstUnreadSeqNum=%d != first result seqNum=%d", this.firstUnreadSeqNum, serialized.getSeqNums().get(0));
        this.firstUnreadSeqNum += (long)serialized.getElements().size();
        return serialized;
    }

    public void write(byte[] bytes, long seqNum, int checkpointMaxWrites) throws IOException {
        if (!this.writable) {
            throw new IllegalStateException(String.format("page=%d is not writable", this.pageNum));
        }
        this.pageIO.write(bytes, seqNum);
        if (this.minSeqNum <= 0L) {
            this.minSeqNum = seqNum;
            this.firstUnreadSeqNum = seqNum;
        }
        ++this.elementCount;
        if (checkpointMaxWrites > 0 && seqNum >= this.lastCheckpoint.maxSeqNum() + (long)checkpointMaxWrites) {
            this.checkpoint();
        }
    }

    public boolean isEmpty() {
        return this.elementCount == 0 || this.isFullyAcked();
    }

    public boolean isFullyRead() {
        return this.unreadCount() <= 0L;
    }

    public boolean isFullyAcked() {
        int cardinality = this.ackedSeqNums.cardinality();
        return this.elementCount > 0 && cardinality == this.ackedSeqNums.length() && cardinality == this.elementCount;
    }

    public long unreadCount() {
        return this.elementCount <= 0 ? 0L : Math.max(0L, this.maxSeqNum() - this.firstUnreadSeqNum + 1L);
    }

    public boolean ack(long firstSeqNum, int count, int checkpointMaxAcks) throws IOException {
        assert (firstSeqNum >= this.minSeqNum) : String.format("seqNum=%d is smaller than minSeqnum=%d", firstSeqNum, this.minSeqNum);
        long maxSeqNum = firstSeqNum + (long)count;
        assert (maxSeqNum <= this.minSeqNum + (long)this.elementCount) : String.format("seqNum=%d is greater than minSeqnum=%d + elementCount=%d = %d", maxSeqNum, this.minSeqNum, this.elementCount, this.minSeqNum + (long)this.elementCount);
        int offset = Ints.checkedCast((long)(firstSeqNum - this.minSeqNum));
        this.ackedSeqNums.flip(offset, offset + count);
        long firstUnackedSeqNum = this.firstUnackedSeqNum();
        boolean done = this.isFullyAcked();
        if (done) {
            if (this.writable) {
                this.headPageCheckpoint();
            } else {
                this.purge();
                CheckpointIO cpIO = this.queue.getCheckpointIO();
                cpIO.purge(cpIO.tailFileName(this.pageNum));
            }
            assert (firstUnackedSeqNum >= this.minSeqNum + (long)this.elementCount - 1L) : String.format("invalid firstUnackedSeqNum=%d for minSeqNum=%d and elementCount=%d and cardinality=%d", firstUnackedSeqNum, this.minSeqNum, this.elementCount, this.ackedSeqNums.cardinality());
        } else if (checkpointMaxAcks > 0 && firstUnackedSeqNum >= this.lastCheckpoint.getFirstUnackedSeqNum() + (long)checkpointMaxAcks) {
            this.checkpoint();
        }
        return done;
    }

    public void checkpoint() throws IOException {
        if (this.writable) {
            this.headPageCheckpoint();
        } else {
            this.tailPageCheckpoint();
        }
    }

    private void headPageCheckpoint() throws IOException {
        if (this.elementCount > this.lastCheckpoint.getElementCount()) {
            this.pageIO.ensurePersisted();
            this.forceCheckpoint();
        } else {
            Checkpoint checkpoint = new Checkpoint(this.pageNum, this.queue.firstUnackedPageNum(), this.firstUnackedSeqNum(), this.minSeqNum, this.elementCount);
            if (!checkpoint.equals(this.lastCheckpoint)) {
                CheckpointIO io = this.queue.getCheckpointIO();
                io.write(io.headFileName(), checkpoint);
                this.lastCheckpoint = checkpoint;
            }
        }
    }

    public void tailPageCheckpoint() throws IOException {
        CheckpointIO io = this.queue.getCheckpointIO();
        this.lastCheckpoint = io.write(io.tailFileName(this.pageNum), this.pageNum, 0, this.firstUnackedSeqNum(), this.minSeqNum, this.elementCount);
    }

    public void ensurePersistedUpto(long seqNum) throws IOException {
        long lastCheckpointUptoSeqNum = this.lastCheckpoint.getMinSeqNum() + (long)this.lastCheckpoint.getElementCount();
        if (seqNum > lastCheckpointUptoSeqNum) {
            this.checkpoint();
        }
    }

    public void forceCheckpoint() throws IOException {
        Checkpoint checkpoint = new Checkpoint(this.pageNum, this.queue.firstUnackedPageNum(), this.firstUnackedSeqNum(), this.minSeqNum, this.elementCount);
        CheckpointIO io = this.queue.getCheckpointIO();
        io.write(io.headFileName(), checkpoint);
        this.lastCheckpoint = checkpoint;
    }

    public void behead() throws IOException {
        assert (this.writable) : "cannot behead a tail page";
        this.headPageCheckpoint();
        this.writable = false;
        this.lastCheckpoint = new Checkpoint(0, 0, 0L, 0L, 0);
        this.tailPageCheckpoint();
    }

    public void deactivate() throws IOException {
        this.getPageIO().deactivate();
    }

    public boolean hasSpace(int byteSize) {
        return this.pageIO.hasSpace(byteSize);
    }

    public boolean hasCapacity(int byteSize) {
        return this.pageIO.persistedByteCount(byteSize) <= this.pageIO.getCapacity();
    }

    @Override
    public void close() throws IOException {
        this.checkpoint();
        this.pageIO.close();
    }

    public void purge() throws IOException {
        this.pageIO.purge();
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public long getMinSeqNum() {
        return this.minSeqNum;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public PageIO getPageIO() {
        return this.pageIO;
    }

    protected long maxSeqNum() {
        return this.minSeqNum + (long)this.elementCount - 1L;
    }

    protected long firstUnackedSeqNum() {
        return (long)this.ackedSeqNums.nextClearBit(0) + this.minSeqNum;
    }
}

