/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.logstash.DateNode;
import org.logstash.EpochNode;
import org.logstash.Event;
import org.logstash.KeyNode;
import org.logstash.StaticNode;
import org.logstash.Template;
import org.logstash.TemplateNode;

public class StringInterpolation {
    static Pattern TEMPLATE_TAG = Pattern.compile("%\\{([^}]+)\\}");
    static Map cache;

    private StringInterpolation() {
        cache = new ConcurrentHashMap();
    }

    public void clearCache() {
        cache.clear();
    }

    public int cacheSize() {
        return cache.size();
    }

    public String evaluate(Event event, String template) throws IOException {
        TemplateNode compiledTemplate = (TemplateNode)cache.get(template);
        if (compiledTemplate == null) {
            compiledTemplate = this.compile(template);
            cache.put(template, compiledTemplate);
        }
        return compiledTemplate.evaluate(event);
    }

    public TemplateNode compile(String template) {
        Template compiledTemplate = new Template();
        if (template.indexOf(37) == -1) {
            compiledTemplate.add(new StaticNode(template));
        } else {
            Matcher matcher = TEMPLATE_TAG.matcher(template);
            int pos = 0;
            while (matcher.find()) {
                if (matcher.start() > 0) {
                    compiledTemplate.add(new StaticNode(template.substring(pos, matcher.start())));
                }
                String tag = matcher.group(1);
                compiledTemplate.add(this.identifyTag(tag));
                pos = matcher.end();
            }
            if (pos <= template.length() - 1) {
                compiledTemplate.add(new StaticNode(template.substring(pos)));
            }
        }
        if (compiledTemplate.size() == 1) {
            return compiledTemplate.get(0);
        }
        return compiledTemplate;
    }

    public TemplateNode identifyTag(String tag) {
        if (tag.equals("+%s")) {
            return new EpochNode();
        }
        if (tag.charAt(0) == '+') {
            return new DateNode(tag.substring(1));
        }
        return new KeyNode(tag);
    }

    static StringInterpolation getInstance() {
        return HoldCurrent.INSTANCE;
    }

    protected static class HoldCurrent {
        private static final StringInterpolation INSTANCE = new StringInterpolation();

        protected HoldCurrent() {
        }
    }
}

