/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.logstash.FieldReference;

public final class PathCache {
    private static final Map<CharSequence, FieldReference> CACHE = new ConcurrentHashMap<CharSequence, FieldReference>(64, 0.2f, 1);

    private PathCache() {
    }

    public static FieldReference cache(CharSequence reference) {
        FieldReference result = CACHE.get(reference);
        if (result != null) {
            return result;
        }
        return PathCache.parseToCache(reference);
    }

    private static FieldReference parseToCache(CharSequence reference) {
        FieldReference result = FieldReference.parse(reference);
        CACHE.put(reference, result);
        return result;
    }
}

