/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.logstash.Event;
import org.logstash.TemplateNode;
import org.logstash.bivalues.BiValue;

public class KeyNode
implements TemplateNode {
    private String key;

    public KeyNode(String key) {
        this.key = key;
    }

    @Override
    public String evaluate(Event event) throws IOException {
        Object value = event.getField(this.key);
        if (value != null) {
            if (value instanceof List) {
                return KeyNode.join((List)value, ",");
            }
            if (value instanceof Map) {
                ObjectMapper mapper = new ObjectMapper();
                return mapper.writeValueAsString(value);
            }
            return event.getField(this.key).toString();
        }
        return "%{" + this.key + "}";
    }

    public static String join(List<?> list, String delim) {
        int len = list.size();
        if (len == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(KeyNode.toString(list.get(0), delim));
        for (int i = 1; i < len; ++i) {
            result.append(delim);
            result.append(KeyNode.toString(list.get(i), delim));
        }
        return result.toString();
    }

    private static String toString(Object value, String delim) {
        if (value == null) {
            return "";
        }
        if (value instanceof List) {
            return KeyNode.join((List)value, delim);
        }
        if (value instanceof BiValue) {
            return value.toString();
        }
        return value.toString();
    }
}

