/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class FieldReference {
    public static final int META_PARENT = 0;
    public static final int META_CHILD = 1;
    private static final int DATA_CHILD = -1;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Pattern SPLIT_PATTERN = Pattern.compile("[\\[\\]]");
    private static final Map<FieldReference, FieldReference> DEDUP = new HashMap<FieldReference, FieldReference>(64);
    public static final FieldReference TIMESTAMP_REFERENCE = FieldReference.deduplicate(new FieldReference(EMPTY_STRING_ARRAY, "@timestamp", -1));
    private static final FieldReference METADATA_PARENT_REFERENCE = new FieldReference(EMPTY_STRING_ARRAY, "@metadata", 0);
    private final String[] path;
    private final String key;
    private final int hash;
    private final int type;

    private FieldReference(String[] path, String key, int type) {
        this.key = key;
        this.type = type;
        this.path = path;
        this.hash = FieldReference.calculateHash(this.key, this.path, this.type);
    }

    public static FieldReference parse(CharSequence reference) {
        String[] parts = SPLIT_PATTERN.split(reference);
        ArrayList<String> path = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if (part.isEmpty()) continue;
            path.add(part.intern());
        }
        String key = ((String)path.remove(path.size() - 1)).intern();
        boolean empty = path.isEmpty();
        if (empty && key.equals("@metadata")) {
            return METADATA_PARENT_REFERENCE;
        }
        if (!empty && ((String)path.get(0)).equals("@metadata")) {
            return FieldReference.deduplicate(new FieldReference(path.subList(1, path.size()).toArray(EMPTY_STRING_ARRAY), key, 1));
        }
        return FieldReference.deduplicate(new FieldReference(path.toArray(EMPTY_STRING_ARRAY), key, -1));
    }

    public int type() {
        return this.type;
    }

    public String[] getPath() {
        return this.path;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof FieldReference)) {
            return false;
        }
        FieldReference other = (FieldReference)that;
        return this.type == other.type && this.key.equals(other.key) && Arrays.equals(this.path, other.path);
    }

    public int hashCode() {
        return this.hash;
    }

    private static synchronized FieldReference deduplicate(FieldReference parsed) {
        FieldReference ret = DEDUP.get(parsed);
        if (ret == null) {
            DEDUP.put(parsed, parsed);
            ret = parsed;
        }
        return ret;
    }

    private static int calculateHash(String key, String[] path, int type) {
        int prime = 31;
        int hash = 31;
        for (String element : path) {
            hash = 31 * hash + element.hashCode();
        }
        hash = 31 * hash + key.hashCode();
        return 31 * hash + type;
    }
}

