/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jruby.RubyString;
import org.logstash.ConvertedList;
import org.logstash.ConvertedMap;

public final class Cloner {
    private Cloner() {
    }

    public static <T> T deep(T input) {
        if (input instanceof Map) {
            return (T)Cloner.deepMap((Map)input);
        }
        if (input instanceof List) {
            return (T)Cloner.deepList((List)input);
        }
        if (input instanceof RubyString) {
            return (T)((RubyString)input).doClone();
        }
        if (input instanceof Collection) {
            throw new ClassCastException("unexpected Collection type " + input.getClass());
        }
        return input;
    }

    private static <E> List<E> deepList(List<E> list) {
        AbstractList clone;
        if (list instanceof LinkedList) {
            clone = new LinkedList();
        } else if (list instanceof ArrayList) {
            clone = new ArrayList();
        } else if (list instanceof ConvertedList) {
            clone = new ArrayList();
        } else {
            throw new ClassCastException("unexpected List type " + list.getClass());
        }
        for (E item : list) {
            clone.add(Cloner.deep(item));
        }
        return clone;
    }

    private static <K, V> Map<K, V> deepMap(Map<K, V> map) {
        AbstractMap clone;
        if (map instanceof LinkedHashMap) {
            clone = new LinkedHashMap();
        } else if (map instanceof TreeMap) {
            clone = new TreeMap();
        } else if (map instanceof HashMap) {
            clone = new HashMap();
        } else if (map instanceof ConvertedMap) {
            clone = new HashMap();
        } else {
            throw new ClassCastException("unexpected Map type " + map.getClass());
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), Cloner.deep(entry.getValue()));
        }
        return clone;
    }
}

