/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.server;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.net.server.AbstractSocketServer;
import org.apache.logging.log4j.core.net.server.JsonInputStreamLogEventBridge;
import org.apache.logging.log4j.core.net.server.LogEventBridge;
import org.apache.logging.log4j.core.net.server.ObjectInputStreamLogEventBridge;
import org.apache.logging.log4j.core.net.server.XmlInputStreamLogEventBridge;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.message.EntryMessage;

public class TcpSocketServer<T extends InputStream>
extends AbstractSocketServer<T> {
    private final ConcurrentMap<Long, SocketHandler> handlers = new ConcurrentHashMap<Long, SocketHandler>();
    private final ServerSocket serverSocket;

    public TcpSocketServer(int port, LogEventBridge<T> logEventInput) throws IOException {
        this(port, logEventInput, new ServerSocket(port));
    }

    public TcpSocketServer(int port, LogEventBridge<T> logEventInput, ServerSocket serverSocket) throws IOException {
        super(port, logEventInput);
        this.serverSocket = serverSocket;
    }

    public static TcpSocketServer<InputStream> createJsonSocketServer(int port) throws IOException {
        LOGGER.entry(new Object[]{"createJsonSocketServer", port});
        TcpSocketServer<InputStream> socketServer = new TcpSocketServer<InputStream>(port, new JsonInputStreamLogEventBridge());
        return (TcpSocketServer)LOGGER.exit(socketServer);
    }

    public static TcpSocketServer<ObjectInputStream> createSerializedSocketServer(int port) throws IOException {
        LOGGER.entry(new Object[]{port});
        TcpSocketServer<ObjectInputStream> socketServer = new TcpSocketServer<ObjectInputStream>(port, new ObjectInputStreamLogEventBridge());
        return (TcpSocketServer)LOGGER.exit(socketServer);
    }

    public static TcpSocketServer<InputStream> createXmlSocketServer(int port) throws IOException {
        LOGGER.entry(new Object[]{port});
        TcpSocketServer<InputStream> socketServer = new TcpSocketServer<InputStream>(port, new XmlInputStreamLogEventBridge());
        return (TcpSocketServer)LOGGER.exit(socketServer);
    }

    public static void main(String[] args) throws Exception {
        String line;
        if (args.length < 1 || args.length > 2) {
            System.err.println("Incorrect number of arguments");
            TcpSocketServer.printUsage();
            return;
        }
        int port = Integer.parseInt(args[0]);
        if (port <= 0 || port >= 65534) {
            System.err.println("Invalid port number");
            TcpSocketServer.printUsage();
            return;
        }
        if (args.length == 2 && args[1].length() > 0) {
            ConfigurationFactory.setConfigurationFactory(new AbstractSocketServer.ServerConfigurationFactory(args[1]));
        }
        TcpSocketServer<ObjectInputStream> socketServer = TcpSocketServer.createSerializedSocketServer(port);
        Log4jThread serverThread = new Log4jThread(socketServer);
        serverThread.start();
        Charset enc = Charset.defaultCharset();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, enc));
        while (!((line = reader.readLine()) == null || line.equalsIgnoreCase("Quit") || line.equalsIgnoreCase("Stop") || line.equalsIgnoreCase("Exit"))) {
        }
        socketServer.shutdown();
        serverThread.join();
    }

    private static void printUsage() {
        System.out.println("Usage: ServerSocket port configFilePath");
    }

    @Override
    public void run() {
        EntryMessage entry = this.logger.traceEntry();
        while (this.isActive()) {
            if (this.serverSocket.isClosed()) {
                return;
            }
            try {
                this.logger.debug("Socket accept()...");
                Socket clientSocket = this.serverSocket.accept();
                this.logger.debug("Socket accepted: {}", (Object)clientSocket);
                clientSocket.setSoLinger(true, 0);
                SocketHandler handler = new SocketHandler(clientSocket);
                this.handlers.put(handler.getId(), handler);
                handler.start();
            }
            catch (IOException e) {
                if (this.serverSocket.isClosed()) {
                    this.logger.traceExit(entry);
                    return;
                }
                this.logger.error("Exception encountered on accept. Ignoring. Stack Trace :", (Throwable)e);
            }
        }
        for (Map.Entry handlerEntry : this.handlers.entrySet()) {
            SocketHandler handler = (SocketHandler)handlerEntry.getValue();
            handler.shutdown();
            try {
                handler.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logger.traceExit(entry);
    }

    public void shutdown() throws IOException {
        EntryMessage entry = this.logger.traceEntry();
        this.setActive(false);
        Thread.currentThread().interrupt();
        this.serverSocket.close();
        this.logger.traceExit(entry);
    }

    private class SocketHandler
    extends Thread {
        private final T inputStream;
        private volatile boolean shutdown = false;

        public SocketHandler(Socket socket) throws IOException {
            this.inputStream = TcpSocketServer.this.logEventInput.wrapStream(socket.getInputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EntryMessage entry = TcpSocketServer.this.logger.traceEntry();
            boolean closed = false;
            try {
                try {
                    while (!this.shutdown) {
                        TcpSocketServer.this.logEventInput.logEvents(this.inputStream, TcpSocketServer.this);
                    }
                }
                catch (EOFException e) {
                    closed = true;
                }
                catch (OptionalDataException e) {
                    TcpSocketServer.this.logger.error("OptionalDataException eof=" + e.eof + " length=" + e.length, (Throwable)e);
                }
                catch (IOException e) {
                    TcpSocketServer.this.logger.error("IOException encountered while reading from socket", (Throwable)e);
                }
                if (!closed) {
                    try {
                        ((InputStream)this.inputStream).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                TcpSocketServer.this.handlers.remove(this.getId());
            }
            TcpSocketServer.this.logger.traceExit(entry);
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }
    }
}

