/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.monitors;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;

public class ProcessMonitor {
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final MBeanServer platformMxBean = ManagementFactory.getPlatformMBeanServer();

    public Report detect() {
        return new Report();
    }

    public static class Report {
        private long memTotalVirtualInBytes = -1L;
        private short cpuSystemPercent = (short)-4;
        private short cpuProcessPercent = (short)-3;
        private long cpuMillisTotal = -1L;
        private boolean isUnix;
        private long openFds = -1L;
        private long maxFds = -1L;
        private Map<String, Object> map = new HashMap<String, Object>();

        Report() {
            this.isUnix = osMxBean instanceof UnixOperatingSystemMXBean;
            if (this.isUnix) {
                UnixOperatingSystemMXBean unixOsBean = (UnixOperatingSystemMXBean)osMxBean;
                this.openFds = unixOsBean.getOpenFileDescriptorCount();
                this.maxFds = unixOsBean.getMaxFileDescriptorCount();
                this.cpuMillisTotal = TimeUnit.MILLISECONDS.convert(unixOsBean.getProcessCpuTime(), TimeUnit.NANOSECONDS);
                this.cpuProcessPercent = this.scaleLoadToPercent(unixOsBean.getProcessCpuLoad());
                this.cpuSystemPercent = this.scaleLoadToPercent(unixOsBean.getSystemCpuLoad());
                this.memTotalVirtualInBytes = unixOsBean.getCommittedVirtualMemorySize();
            }
        }

        public Map<String, Object> toMap() {
            this.map.put("open_file_descriptors", this.openFds);
            this.map.put("max_file_descriptors", this.maxFds);
            this.map.put("is_unix", this.isUnix);
            HashMap<String, Number> cpuMap = new HashMap<String, Number>();
            this.map.put("cpu", cpuMap);
            cpuMap.put("total_in_millis", this.cpuMillisTotal);
            cpuMap.put("process_percent", this.cpuProcessPercent);
            cpuMap.put("system_percent", this.cpuSystemPercent);
            HashMap<String, Long> memoryMap = new HashMap<String, Long>();
            this.map.put("mem", memoryMap);
            memoryMap.put("total_virtual_in_bytes", this.memTotalVirtualInBytes);
            return this.map;
        }

        private short scaleLoadToPercent(double load) {
            if (osMxBean instanceof UnixOperatingSystemMXBean) {
                if (load >= 0.0) {
                    return (short)(load * 100.0);
                }
                return -1;
            }
            return -1;
        }
    }
}

