/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.bivalues;

import java.io.ObjectStreamException;
import org.jruby.Ruby;
import org.jruby.RubyFloat;
import org.logstash.bivalues.BiValue;
import org.logstash.bivalues.BiValueCommon;

public class FloatBiValue
extends BiValueCommon<RubyFloat, Float>
implements BiValue<RubyFloat, Float> {
    public FloatBiValue(RubyFloat rubyValue) {
        this.rubyValue = rubyValue;
        this.javaValue = null;
    }

    public FloatBiValue(Float javaValue) {
        this.javaValue = javaValue;
        this.rubyValue = null;
    }

    private FloatBiValue() {
    }

    @Override
    protected void addRuby(Ruby runtime) {
        this.rubyValue = RubyFloat.newFloat((Ruby)runtime, (double)((Float)this.javaValue).floatValue());
    }

    @Override
    protected void addJava() {
        double value = ((RubyFloat)this.rubyValue).getDoubleValue();
        if ((double)((float)value) != value) {
            throw new ArithmeticException("Float overflow - Incorrect FloatBiValue usage: BiValues should pick DoubleBiValue for RubyFloat");
        }
        this.javaValue = Float.valueOf((float)value);
    }

    private Object writeReplace() throws ObjectStreamException {
        return FloatBiValue.newProxy(this);
    }
}

