/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.bivalues;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.Timestamp;
import org.logstash.bivalues.BiValue;
import org.logstash.bivalues.BigDecimalBiValue;
import org.logstash.bivalues.BigIntegerBiValue;
import org.logstash.bivalues.BooleanBiValue;
import org.logstash.bivalues.DoubleBiValue;
import org.logstash.bivalues.FloatBiValue;
import org.logstash.bivalues.IntegerBiValue;
import org.logstash.bivalues.JavaProxyBiValue;
import org.logstash.bivalues.LongBiValue;
import org.logstash.bivalues.NullBiValue;
import org.logstash.bivalues.StringBiValue;
import org.logstash.bivalues.SymbolBiValue;
import org.logstash.bivalues.TimestampBiValue;
import org.logstash.ext.JrubyTimestampExtLibrary;

public enum BiValues {
    ORG_LOGSTASH_EXT_JRUBYTIMESTAMPEXTLIBRARY$RUBYTIMESTAMP(BiValueType.TIMESTAMP),
    ORG_LOGSTASH_TIMESTAMP(BiValueType.TIMESTAMP),
    JAVA_LANG_BOOLEAN(BiValueType.BOOLEAN),
    JAVA_LANG_DOUBLE(BiValueType.DOUBLE),
    JAVA_LANG_FLOAT(BiValueType.FLOAT),
    JAVA_LANG_INTEGER(BiValueType.INT),
    JAVA_LANG_LONG(BiValueType.LONG),
    JAVA_LANG_STRING(BiValueType.STRING),
    JAVA_MATH_BIGDECIMAL(BiValueType.DECIMAL),
    JAVA_MATH_BIGINTEGER(BiValueType.BIGINT),
    ORG_JRUBY_EXT_BIGDECIMAL_RUBYBIGDECIMAL(BiValueType.DECIMAL),
    ORG_JRUBY_JAVA_PROXIES_CONCRETEJAVAPROXY(BiValueType.JAVAPROXY),
    ORG_JRUBY_RUBYBIGNUM(BiValueType.BIGINT),
    ORG_JRUBY_RUBYBOOLEAN$FALSE(BiValueType.BOOLEAN),
    ORG_JRUBY_RUBYBOOLEAN$TRUE(BiValueType.BOOLEAN),
    ORG_JRUBY_RUBYBOOLEAN(BiValueType.BOOLEAN),
    ORG_JRUBY_RUBYFIXNUM(BiValueType.LONG),
    ORG_JRUBY_RUBYFLOAT(BiValueType.DOUBLE),
    ORG_JRUBY_RUBYINTEGER(BiValueType.LONG),
    ORG_JRUBY_RUBYNIL(BiValueType.NULL),
    ORG_JRUBY_RUBYSTRING(BiValueType.STRING),
    ORG_JRUBY_RUBYSYMBOL(BiValueType.SYMBOL),
    NULL(BiValueType.NULL);

    private static final NullBiValue NULL_BI_VALUE;
    private final BiValueType biValueType;
    private static final HashMap<String, String> nameCache;

    private static HashMap<String, String> initCache() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("org.logstash.Timestamp", "ORG_LOGSTASH_TIMESTAMP");
        hm.put("org.logstash.ext.JrubyTimestampExtLibrary$RubyTimestamp", "ORG_LOGSTASH_EXT_JRUBYTIMESTAMPEXTLIBRARY$RUBYTIMESTAMP");
        hm.put("java.lang.Boolean", "JAVA_LANG_BOOLEAN");
        hm.put("java.lang.Double", "JAVA_LANG_DOUBLE");
        hm.put("java.lang.Float", "JAVA_LANG_FLOAT");
        hm.put("java.lang.Integer", "JAVA_LANG_INTEGER");
        hm.put("java.lang.Long", "JAVA_LANG_LONG");
        hm.put("java.lang.String", "JAVA_LANG_STRING");
        hm.put("java.math.BigDecimal", "JAVA_MATH_BIGDECIMAL");
        hm.put("java.math.BigInteger", "JAVA_MATH_BIGINTEGER");
        hm.put("org.jruby.RubyBignum", "ORG_JRUBY_RUBYBIGNUM");
        hm.put("org.jruby.RubyBoolean", "ORG_JRUBY_RUBYBOOLEAN");
        hm.put("org.jruby.RubyBoolean$False", "ORG_JRUBY_RUBYBOOLEAN$FALSE");
        hm.put("org.jruby.RubyBoolean$True", "ORG_JRUBY_RUBYBOOLEAN$TRUE");
        hm.put("org.jruby.RubyFixnum", "ORG_JRUBY_RUBYFIXNUM");
        hm.put("org.jruby.RubyFloat", "ORG_JRUBY_RUBYFLOAT");
        hm.put("org.jruby.RubyInteger", "ORG_JRUBY_RUBYINTEGER");
        hm.put("org.jruby.RubyNil", "ORG_JRUBY_RUBYNIL");
        hm.put("org.jruby.RubyString", "ORG_JRUBY_RUBYSTRING");
        hm.put("org.jruby.RubySymbol", "ORG_JRUBY_RUBYSYMBOL");
        hm.put("org.jruby.ext.bigdecimal.RubyBigDecimal", "ORG_JRUBY_EXT_BIGDECIMAL_RUBYBIGDECIMAL");
        hm.put("org.jruby.java.proxies.ConcreteJavaProxy", "ORG_JRUBY_JAVA_PROXIES_CONCRETEJAVAPROXY");
        return hm;
    }

    private BiValues(BiValueType biValueType) {
        this.biValueType = biValueType;
    }

    private BiValue build(Object value) {
        return this.biValueType.build(value);
    }

    public static BiValue newBiValue(Object o) {
        if (o == null) {
            return NULL_BI_VALUE;
        }
        BiValues bvs = BiValues.valueOf(BiValues.fetchName(o));
        return bvs.build(o);
    }

    private static String fetchName(Object o) {
        String cls = o.getClass().getName();
        if (nameCache.containsKey(cls)) {
            return nameCache.get(cls);
        }
        String toCache = cls.toUpperCase().replace('.', '_');
        nameCache.put(cls, toCache);
        return toCache;
    }

    static {
        NULL_BI_VALUE = NullBiValue.newNullBiValue();
        nameCache = BiValues.initCache();
    }

    private static enum BiValueType {
        STRING{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new StringBiValue((RubyString)value);
                }
                return new StringBiValue((String)value);
            }
        }
        ,
        SYMBOL{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new SymbolBiValue((RubySymbol)value);
                }
                return new SymbolBiValue((String)value);
            }
        }
        ,
        LONG{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new LongBiValue((RubyInteger)value);
                }
                return new LongBiValue((Long)value);
            }
        }
        ,
        INT{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new IntegerBiValue((RubyInteger)value);
                }
                return new IntegerBiValue((Integer)value);
            }
        }
        ,
        DOUBLE{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new DoubleBiValue((RubyFloat)value);
                }
                return new DoubleBiValue((Double)value);
            }
        }
        ,
        FLOAT{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new DoubleBiValue((RubyFloat)value);
                }
                return new FloatBiValue((Float)value);
            }
        }
        ,
        DECIMAL{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new BigDecimalBiValue((RubyBigDecimal)value);
                }
                return new BigDecimalBiValue((BigDecimal)value);
            }
        }
        ,
        BOOLEAN{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new BooleanBiValue((RubyBoolean)value);
                }
                return new BooleanBiValue((Boolean)value);
            }
        }
        ,
        TIMESTAMP{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new TimestampBiValue((JrubyTimestampExtLibrary.RubyTimestamp)((Object)value));
                }
                return new TimestampBiValue((Timestamp)value);
            }
        }
        ,
        NULL{

            @Override
            NullBiValue build(Object value) {
                return NULL_BI_VALUE;
            }
        }
        ,
        BIGINT{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new BigIntegerBiValue((RubyBignum)value);
                }
                return new BigIntegerBiValue((BigInteger)value);
            }
        }
        ,
        JAVAPROXY{

            @Override
            BiValue build(Object value) {
                if (value instanceof IRubyObject) {
                    return new JavaProxyBiValue((JavaProxy)value);
                }
                return new JavaProxyBiValue(value);
            }
        };


        abstract BiValue build(Object var1);
    }
}

