/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.bivalues;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.bivalues.BiValue;
import org.logstash.bivalues.BiValues;

public abstract class BiValueCommon<R extends IRubyObject, J>
implements Serializable {
    protected transient R rubyValue;
    protected J javaValue;

    public R rubyValue(Ruby runtime) {
        if (this.hasRubyValue()) {
            return this.rubyValue;
        }
        this.addRuby(runtime);
        return this.rubyValue;
    }

    @JsonValue
    public J javaValue() {
        if (this.javaValue == null) {
            this.addJava();
        }
        return this.javaValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.hasJavaValue() && this.javaValue.getClass().isAssignableFrom(o.getClass())) {
            return this.javaValue.equals(o);
        }
        if (!(o instanceof BiValue)) {
            return false;
        }
        BiValueCommon other = (BiValueCommon)o;
        return other.hasJavaValue() && other.javaValue().equals(this.javaValue) || other.hasRubyValue() && other.rubyValueUnconverted().equals(this.rubyValue);
    }

    public int hashCode() {
        if (this.hasRubyValue()) {
            return this.rubyValue.hashCode();
        }
        if (this.hasJavaValue()) {
            return this.javaValue.hashCode();
        }
        return 0;
    }

    public R rubyValueUnconverted() {
        return this.rubyValue;
    }

    public boolean hasRubyValue() {
        return null != this.rubyValue;
    }

    public boolean hasJavaValue() {
        return null != this.javaValue;
    }

    protected abstract void addRuby(Ruby var1);

    protected abstract void addJava();

    public String toString() {
        if (this.hasRubyValue()) {
            this.javaValue();
        }
        if (this.javaValue == null) {
            return "";
        }
        return String.valueOf(this.javaValue);
    }

    protected static Object newProxy(BiValue instance) {
        return new SerializationProxy(instance);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = -1749700725129586973L;
        private final Object javaValue;

        public SerializationProxy(BiValue o) {
            this.javaValue = o.javaValue();
        }

        private Object readResolve() throws ObjectStreamException {
            return BiValues.newBiValue(this.javaValue);
        }
    }
}

