/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.jruby.RubySymbol;
import org.logstash.Accessors;
import org.logstash.Cloner;
import org.logstash.ConvertedList;
import org.logstash.ConvertedMap;
import org.logstash.FieldReference;
import org.logstash.Javafier;
import org.logstash.ObjectMappers;
import org.logstash.PathCache;
import org.logstash.StringInterpolation;
import org.logstash.Timestamp;
import org.logstash.Util;
import org.logstash.Valuefier;
import org.logstash.ackedqueue.Queueable;
import org.logstash.bivalues.BiValues;
import org.logstash.bivalues.NullBiValue;
import org.logstash.bivalues.StringBiValue;
import org.logstash.bivalues.TimeBiValue;
import org.logstash.bivalues.TimestampBiValue;
import org.logstash.ext.JrubyTimestampExtLibrary;

public final class Event
implements Cloneable,
Queueable {
    private boolean cancelled;
    private ConvertedMap data;
    private ConvertedMap metadata;
    private Timestamp timestamp;
    public static final String METADATA = "@metadata";
    public static final String METADATA_BRACKETS = "[@metadata]";
    public static final String TIMESTAMP = "@timestamp";
    public static final String TIMESTAMP_FAILURE_TAG = "_timestampparsefailure";
    public static final String TIMESTAMP_FAILURE_FIELD = "_@timestamp";
    public static final String VERSION = "@version";
    public static final String VERSION_ONE = "1";
    private static final String DATA_MAP_KEY = "DATA";
    private static final String META_MAP_KEY = "META";
    private static final FieldReference TAGS_FIELD = PathCache.cache("tags");
    private static final Logger logger = LogManager.getLogger(Event.class);

    public Event() {
        this.metadata = new ConvertedMap(10);
        this.data = new ConvertedMap(10);
        this.data.put(VERSION, VERSION_ONE);
        this.cancelled = false;
        this.timestamp = new Timestamp();
        this.data.put(TIMESTAMP, this.timestamp);
    }

    public Event(Map data) {
        this(ConvertedMap.newFromMap(data));
    }

    public Event(ConvertedMap data) {
        this.data = data;
        if (!this.data.containsKey(VERSION)) {
            this.data.put(VERSION, VERSION_ONE);
        }
        this.metadata = this.data.containsKey(METADATA) ? ConvertedMap.newFromMap((Map)this.data.remove(METADATA)) : new ConvertedMap(10);
        this.cancelled = false;
        Object providedTimestamp = data.get(TIMESTAMP);
        Timestamp parsedTimestamp = Event.initTimestamp(providedTimestamp);
        this.timestamp = parsedTimestamp == null ? Timestamp.now() : parsedTimestamp;
        Accessors.set(data, FieldReference.TIMESTAMP_REFERENCE, this.timestamp);
        if (parsedTimestamp == null) {
            this.tag(TIMESTAMP_FAILURE_TAG);
            this.setField(TIMESTAMP_FAILURE_FIELD, providedTimestamp);
        }
    }

    public ConvertedMap getData() {
        return this.data;
    }

    public ConvertedMap getMetadata() {
        return this.metadata;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void uncancel() {
        this.cancelled = false;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public Timestamp getTimestamp() throws IOException {
        if (this.data.containsKey(TIMESTAMP)) {
            return this.timestamp;
        }
        throw new IOException("fails");
    }

    public void setTimestamp(Timestamp t) {
        this.timestamp = t;
        this.data.put(TIMESTAMP, this.timestamp);
    }

    public Object getField(String reference) {
        Object unconverted = this.getUnconvertedField(PathCache.cache(reference));
        return unconverted == null ? null : Javafier.deep(unconverted);
    }

    public Object getUnconvertedField(String reference) {
        return this.getUnconvertedField(PathCache.cache(reference));
    }

    public Object getUnconvertedField(FieldReference field) {
        switch (field.type()) {
            case 0: {
                return this.metadata;
            }
            case 1: {
                return Accessors.get(this.metadata, field);
            }
        }
        return Accessors.get(this.data, field);
    }

    public void setField(String reference, Object value) {
        this.setField(PathCache.cache(reference), value);
    }

    public void setField(FieldReference field, Object value) {
        switch (field.type()) {
            case 0: {
                this.metadata = ConvertedMap.newFromMap((Map)value);
                break;
            }
            case 1: {
                Accessors.set(this.metadata, field, value);
                break;
            }
            default: {
                Accessors.set(this.data, field, Valuefier.convert(value));
            }
        }
    }

    public boolean includes(String field) {
        return this.includes(PathCache.cache(field));
    }

    public boolean includes(FieldReference field) {
        switch (field.type()) {
            case 0: {
                return true;
            }
            case 1: {
                return Accessors.includes(this.metadata, field);
            }
        }
        return Accessors.includes(this.data, field);
    }

    public byte[] toBinary() throws IOException {
        return this.toBinaryFromMap(this.toSerializableMap());
    }

    private Map<String, Map<String, Object>> toSerializableMap() {
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        hashMap.put(DATA_MAP_KEY, this.data);
        hashMap.put(META_MAP_KEY, this.metadata);
        return hashMap;
    }

    private byte[] toBinaryFromMap(Map<String, Map<String, Object>> representation) throws IOException {
        return ObjectMappers.CBOR_MAPPER.writeValueAsBytes(representation);
    }

    private static Event fromSerializableMap(Map<String, Map<String, Object>> representation) throws IOException {
        if (!representation.containsKey(DATA_MAP_KEY)) {
            throw new IOException("The deserialized Map must contain the \"DATA\" key");
        }
        if (!representation.containsKey(META_MAP_KEY)) {
            throw new IOException("The deserialized Map must contain the \"META\" key");
        }
        Map<String, Object> dataMap = representation.get(DATA_MAP_KEY);
        dataMap.put(METADATA, representation.get(META_MAP_KEY));
        return new Event(dataMap);
    }

    public static Event fromBinary(byte[] source) throws IOException {
        if (source == null || source.length == 0) {
            return new Event();
        }
        return Event.fromSerializableMap(Event.fromBinaryToMap(source));
    }

    private static Map<String, Map<String, Object>> fromBinaryToMap(byte[] source) throws IOException {
        Object o = ObjectMappers.CBOR_MAPPER.readValue(source, HashMap.class);
        if (o == null) {
            throw new IOException("incompatible from binary object type only HashMap is supported");
        }
        return (Map)o;
    }

    public String toJson() throws IOException {
        return ObjectMappers.JSON_MAPPER.writeValueAsString((Object)this.data);
    }

    public static Event[] fromJson(String json) throws IOException {
        Event[] result;
        if (json == null || json.trim().isEmpty()) {
            return new Event[0];
        }
        Object o = ObjectMappers.JSON_MAPPER.readValue(json, Object.class);
        if (o instanceof Map) {
            result = new Event[]{new Event((Map)o)};
        } else if (o instanceof List) {
            result = new Event[((List)o).size()];
            int i = 0;
            for (Object e : (List)o) {
                if (!(e instanceof Map)) {
                    throw new IOException("incompatible inner json array object type=" + e.getClass().getName() + " , only hash map is supported");
                }
                result[i++] = new Event((Map)e);
            }
        } else {
            throw new IOException("incompatible json object type=" + o.getClass().getName() + " , only hash map or arrays are supported");
        }
        return result;
    }

    public Map toMap() {
        return Cloner.deep(this.data);
    }

    public Event overwrite(Event e) {
        this.data = e.getData();
        this.cancelled = e.isCancelled();
        try {
            this.timestamp = e.getTimestamp();
        }
        catch (IOException exception) {
            this.timestamp = new Timestamp();
        }
        return this;
    }

    public Event append(Event e) {
        Util.mapMerge(this.data, e.data);
        return this;
    }

    public Object remove(String path) {
        return this.remove(PathCache.cache(path));
    }

    public Object remove(FieldReference field) {
        return Accessors.del(this.data, field);
    }

    public String sprintf(String s) throws IOException {
        return StringInterpolation.getInstance().evaluate(this, s);
    }

    public Event clone() {
        ConvertedMap map = ConvertedMap.newFromMap(Cloner.deep(this.data));
        map.put(METADATA, Cloner.deep(this.metadata));
        return new Event(map);
    }

    public String toString() {
        Object hostField = this.getField("host");
        Object messageField = this.getField("message");
        String hostMessageString = (hostField != null ? hostField.toString() : "%{host}") + " " + (messageField != null ? messageField.toString() : "%{message}");
        try {
            return this.getTimestamp().toIso8601() + " " + hostMessageString;
        }
        catch (IOException e) {
            return hostMessageString;
        }
    }

    private static Timestamp initTimestamp(Object o) {
        if (o == null || o instanceof NullBiValue) {
            return new Timestamp();
        }
        return Event.parseTimestamp(o);
    }

    private static Timestamp parseTimestamp(Object o) {
        try {
            if (o instanceof String) {
                return new Timestamp((String)o);
            }
            if (o instanceof StringBiValue) {
                return new Timestamp(((StringBiValue)o).javaValue());
            }
            if (o instanceof TimeBiValue) {
                return new Timestamp((DateTime)((TimeBiValue)o).javaValue());
            }
            if (o instanceof JrubyTimestampExtLibrary.RubyTimestamp) {
                return new Timestamp(((JrubyTimestampExtLibrary.RubyTimestamp)((Object)o)).getTimestamp());
            }
            if (o instanceof Timestamp) {
                return new Timestamp((Timestamp)o);
            }
            if (o instanceof TimestampBiValue) {
                return new Timestamp((Timestamp)((TimestampBiValue)o).javaValue());
            }
            if (o instanceof DateTime) {
                return new Timestamp((DateTime)o);
            }
            if (o instanceof Date) {
                return new Timestamp((Date)o);
            }
            if (o instanceof RubySymbol) {
                return new Timestamp(((RubySymbol)o).asJavaString());
            }
            logger.warn("Unrecognized @timestamp value type=" + o.getClass().toString());
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing @timestamp string value=" + o.toString());
        }
        return null;
    }

    public void tag(String tag) {
        Object tags = Accessors.get(this.data, TAGS_FIELD);
        if (tags == null) {
            this.initTag(tag);
        } else {
            this.existingTag(Javafier.deep(tags), tag);
        }
    }

    private void initTag(String tag) {
        ConvertedList list = new ConvertedList(1);
        list.add(BiValues.newBiValue(tag));
        Accessors.set(this.data, TAGS_FIELD, list);
    }

    private void existingTag(Object tags, String tag) {
        if (tags instanceof List) {
            this.appendTag((List)tags, tag);
        } else {
            this.scalarTagFallback((String)tags, tag);
        }
    }

    private void appendTag(List<String> tags, String tag) {
        if (!tags.contains(tag)) {
            tags.add(tag);
            Accessors.set(this.data, TAGS_FIELD, ConvertedList.newFromList(tags));
        }
    }

    private void scalarTagFallback(String existing, String tag) {
        ArrayList<String> tags = new ArrayList<String>(2);
        tags.add(existing);
        this.appendTag(tags, tag);
    }

    @Override
    public byte[] serialize() throws IOException {
        Map<String, Map<String, Object>> dataMap = this.toSerializableMap();
        return this.toBinaryFromMap(dataMap);
    }

    public byte[] serializeWithoutSeqNum() throws IOException {
        return this.toBinary();
    }

    public static Event deserialize(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return new Event();
        }
        Map<String, Map<String, Object>> dataMap = Event.fromBinaryToMap(data);
        return Event.fromSerializableMap(dataMap);
    }
}

