/*
 * Decompiled with CFR 0.152.
 */
package org.yecht;

import org.yecht.Data;
import org.yecht.KindTag;
import org.yecht.MapPart;
import org.yecht.MapStyle;
import org.yecht.Pointer;
import org.yecht.ScalarStyle;
import org.yecht.SeqStyle;
import org.yecht.YAML;

public class Node {
    public Object id = null;
    public KindTag kind;
    public String type_id;
    public String anchor;
    public Data data;
    public Object shortcut;

    Node() {
    }

    public String toString() {
        if (this.kind != null) {
            switch (this.kind) {
                case Str: {
                    return "Str[id=" + this.id + ", type=" + this.type_id + ", val=" + this.data + "]";
                }
                case Seq: {
                    return "Seq[id=" + this.id + ", type=" + this.type_id + ", val=" + this.data + "]";
                }
                case Map: {
                    return "Map[id=" + this.id + ", type=" + this.type_id + ", val=" + this.data + "]";
                }
            }
        }
        return "other[id=" + this.id + ", type=" + this.type_id + ", val=" + this.data + "]";
    }

    public void replaceStr(Pointer str, int len, ScalarStyle style) {
        Data.Str s2 = (Data.Str)this.data;
        s2.ptr = Pointer.create(new byte[len], 0);
        s2.len = len;
        s2.style = style;
        str.memcpy(s2.ptr, len);
    }

    public void strBlowAwayCommas() {
        int go;
        Data.Str d = (Data.Str)this.data;
        byte[] buf = d.ptr.buffer;
        int end2 = go + d.len;
        for (go = d.ptr.start; go < end2; ++go) {
            if (buf[go] != 44) continue;
            --d.len;
            System.arraycopy(buf, go + 1, buf, go, --end2 - go);
        }
    }

    public Pointer strRead() {
        return ((Data.Str)this.data).ptr;
    }

    public void mapEmpty() {
        Data.Map m = (Data.Map)this.data;
        m.idx = 0;
        m.capa = 8;
        m.keys = new Object[m.capa];
        m.values = new Object[m.capa];
    }

    public void mapAdd(Object key2, Object value2) {
        Data.Map m = (Data.Map)this.data;
        int idx = m.idx++;
        if (m.idx > m.capa) {
            m.capa += 8;
            m.keys = YAML.realloc(m.keys, m.capa);
            m.values = YAML.realloc(m.values, m.capa);
        }
        m.keys[idx] = key2;
        m.values[idx] = value2;
    }

    public void mapUpdate(Node map2) {
        int new_capa;
        Data.Map m1 = (Data.Map)this.data;
        Data.Map m2 = (Data.Map)map2.data;
        if (m2.idx < 1) {
            return;
        }
        int new_idx = m1.idx;
        new_idx += m2.idx;
        for (new_capa = m1.capa; new_idx > new_capa; new_capa += 8) {
        }
        if (new_capa > m1.capa) {
            m1.capa = new_capa;
            m1.keys = YAML.realloc(m1.keys, m1.capa);
            m1.values = YAML.realloc(m1.values, m1.capa);
        }
        for (new_idx = 0; new_idx < m2.idx; ++new_idx) {
            m1.keys[m1.idx] = m2.keys[new_idx];
            m1.values[m1.idx] = m2.values[new_idx];
            ++m1.idx;
        }
    }

    public long mapCount() {
        return ((Data.Map)this.data).idx;
    }

    public void mapAssign(MapPart p2, int idx, Object id2) {
        Data.Map m = (Data.Map)this.data;
        if (p2 == MapPart.Key) {
            m.keys[idx] = id2;
        } else {
            m.values[idx] = id2;
        }
    }

    public Object mapRead(MapPart p2, int idx) {
        Data.Map m = (Data.Map)this.data;
        if (p2 == MapPart.Key) {
            return m.keys[idx];
        }
        return m.values[idx];
    }

    public void seqEmpty() {
        Data.Seq s2 = (Data.Seq)this.data;
        s2.idx = 0;
        s2.capa = 8;
        s2.items = new Object[s2.capa];
    }

    public void seqAdd(Object value2) {
        Data.Seq s2 = (Data.Seq)this.data;
        int idx = s2.idx++;
        if (s2.idx > s2.capa) {
            s2.capa += 8;
            s2.items = YAML.realloc(s2.items, s2.capa);
        }
        s2.items[idx] = value2;
    }

    public int seqCount() {
        return ((Data.Seq)this.data).idx;
    }

    public void seqAssign(int idx, Object id2) {
        ((Data.Seq)this.data).items[idx] = id2;
    }

    public Object seqRead(int idx) {
        return ((Data.Seq)this.data).items[idx];
    }

    public static Node allocMap() {
        Data.Map m = new Data.Map();
        m.style = MapStyle.None;
        m.idx = 0;
        m.capa = 8;
        m.keys = new Object[m.capa];
        m.values = new Object[m.capa];
        Node n = KindTag.Map.allocNode();
        n.data = m;
        return n;
    }

    public static Node allocSeq() {
        Data.Seq s2 = new Data.Seq();
        s2.style = SeqStyle.None;
        s2.idx = 0;
        s2.capa = 8;
        s2.items = new Object[s2.capa];
        Node n = KindTag.Seq.allocNode();
        n.data = s2;
        return n;
    }

    public static Node allocStr() {
        Data.Str s2 = new Data.Str();
        s2.style = ScalarStyle.None;
        s2.ptr = Pointer.nullPointer();
        s2.len = 0;
        Node n = KindTag.Str.allocNode();
        n.data = s2;
        return n;
    }

    public static Node newStr(Pointer str, int len, ScalarStyle style) {
        Node n = Node.allocStr();
        Data.Str s2 = (Data.Str)n.data;
        s2.ptr = Pointer.create(new byte[len], 0);
        s2.len = len;
        s2.style = style;
        str.memcpy(s2.ptr, len);
        return n;
    }

    public static Node newMap(Object key2, Object value2) {
        Node n = Node.allocMap();
        n.mapAdd(key2, value2);
        return n;
    }

    public static Node newSeq(Object value2) {
        Node n = Node.allocSeq();
        n.seqAdd(value2);
        return n;
    }
}

