/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.timeout;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.RegexpOptions;

public class Timeout
implements Library {
    private static ScheduledExecutorService timeoutExecutor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new DaemonThreadFactory());

    @Override
    public void load(Ruby runtime, boolean wrap2) throws IOException {
        RubyModule timeout2 = runtime.defineModule("Timeout");
        RubyClass superclass2 = runtime.is1_9() ? runtime.getRuntimeError() : runtime.getInterrupt();
        RubyClass timeoutError = runtime.defineClassUnder("Error", superclass2, superclass2.getAllocator(), timeout2);
        runtime.defineClassUnder("ExitException", runtime.getException(), runtime.getException().getAllocator(), timeout2);
        RubyClass anonException = runtime.defineClassUnder("AnonymousException", runtime.getException(), runtime.getException().getAllocator(), timeout2);
        anonException.setBaseName(null);
        timeout2.defineConstant("THIS_FILE", RubyRegexp.newRegexp(runtime, "timeout\\.rb", new RegexpOptions()));
        timeout2.defineConstant("CALLER_OFFSET", RubyFixnum.newFixnum(runtime, 0L));
        timeout2.defineAnnotatedMethods(Timeout.class);
        runtime.getObject().defineConstant("TimeoutError", timeoutError);
        runtime.getObject().defineAnnotatedMethods(TimeoutToplevel.class);
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, Block block) {
        RubyModule timeout2 = context.runtime.getModule("Timeout");
        if (Timeout.nilOrZeroSeconds(context, seconds)) {
            return block.yieldSpecific(context);
        }
        Ruby runtime = context.runtime;
        if (runtime.getThreadService().getCritical()) {
            return Timeout.raiseBecauseCritical(context);
        }
        RubyThread currentThread = context.getThread();
        AtomicBoolean latch = new AtomicBoolean(false);
        RubyObject id2 = new RubyObject(runtime, runtime.getObject());
        TimeoutTask timeoutRunnable = TimeoutTask.newAnnonymousTask(currentThread, timeout2, latch, id2);
        try {
            return Timeout.yieldWithTimeout(context, seconds, block, timeoutRunnable, latch);
        }
        catch (RaiseException re) {
            Timeout.raiseTimeoutErrorIfMatches(context, timeout2, re, id2);
            throw re;
        }
    }

    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2, IRubyObject seconds, IRubyObject exceptionType, Block block) {
        RubyModule timeout2 = context.runtime.getModule("Timeout");
        if (Timeout.nilOrZeroSeconds(context, seconds)) {
            return block.yieldSpecific(context);
        }
        Ruby runtime = context.runtime;
        if (runtime.getThreadService().getCritical()) {
            return Timeout.raiseBecauseCritical(context);
        }
        RubyThread currentThread = context.getThread();
        AtomicBoolean latch = new AtomicBoolean(false);
        RubyObject id2 = new RubyObject(runtime, runtime.getObject());
        TimeoutTask timeoutRunnable = exceptionType.isNil() ? TimeoutTask.newAnnonymousTask(currentThread, timeout2, latch, id2) : TimeoutTask.newTaskWithException(currentThread, timeout2, latch, exceptionType);
        try {
            return Timeout.yieldWithTimeout(context, seconds, block, timeoutRunnable, latch);
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == Timeout.getAnonymousException(timeout2) && exceptionType.isNil()) {
                Timeout.raiseTimeoutErrorIfMatches(context, timeout2, re, id2);
            }
            throw re;
        }
    }

    private static boolean nilOrZeroSeconds(ThreadContext context, IRubyObject seconds) {
        return seconds.isNil() || Helpers.invoke(context, seconds, "zero?").isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject yieldWithTimeout(ThreadContext context, IRubyObject seconds, Block block, Runnable runnable, AtomicBoolean latch) throws RaiseException {
        long micros = (long)(RubyTime.convertTimeInterval(context, seconds) * 1000000.0);
        ScheduledFuture<?> timeoutFuture = null;
        try {
            timeoutFuture = timeoutExecutor.schedule(runnable, micros, TimeUnit.MICROSECONDS);
            IRubyObject iRubyObject = block.yield(context, seconds);
            return iRubyObject;
        }
        finally {
            if (timeoutFuture != null) {
                Timeout.killTimeoutThread(context, timeoutFuture, latch);
            }
        }
    }

    private static void killTimeoutThread(ThreadContext context, Future timeoutFuture, AtomicBoolean latch) {
        if (latch.compareAndSet(false, true) && timeoutFuture.cancel(false)) {
            if (timeoutExecutor instanceof ScheduledThreadPoolExecutor && timeoutFuture instanceof Runnable) {
                ((ScheduledThreadPoolExecutor)timeoutExecutor).remove((Runnable)((Object)timeoutFuture));
            }
        } else {
            try {
                timeoutFuture.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            context.pollThreadEvents();
        }
    }

    private static IRubyObject raiseBecauseCritical(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubyKernel.raise(context, runtime.getKernel(), new IRubyObject[]{runtime.getThreadError(), runtime.newString("timeout within critical section")}, Block.NULL_BLOCK);
    }

    private static IRubyObject raiseTimeoutErrorIfMatches(ThreadContext context, IRubyObject timeout2, RaiseException ex, IRubyObject id2) {
        if (ex.getException().getInternalVariable("__identifier__") == id2) {
            RubyException rubyException = ex.getException();
            return RubyKernel.raise(context, context.runtime.getKernel(), new IRubyObject[]{Timeout.getClassFrom(timeout2, "Error"), rubyException.callMethod(context, "message"), rubyException.callMethod(context, "backtrace")}, Block.NULL_BLOCK);
        }
        return null;
    }

    private static RubyClass getAnonymousException(IRubyObject timeout2) {
        return Timeout.getClassFrom(timeout2, "AnonymousException");
    }

    private static RubyClass getClassFrom(IRubyObject timeout2, String name2) {
        return ((RubyModule)timeout2).getClass(name2);
    }

    private static class TimeoutTask
    implements Runnable {
        final RubyThread currentThread;
        final AtomicBoolean latch;
        final IRubyObject timeout;
        final IRubyObject id;
        final IRubyObject exception;

        private TimeoutTask(RubyThread currentThread, IRubyObject timeout2, AtomicBoolean latch, IRubyObject id2, IRubyObject exception2) {
            this.currentThread = currentThread;
            this.timeout = timeout2;
            this.latch = latch;
            this.id = id2;
            this.exception = exception2;
        }

        static TimeoutTask newAnnonymousTask(RubyThread currentThread, IRubyObject timeout2, AtomicBoolean latch, IRubyObject id2) {
            return new TimeoutTask(currentThread, timeout2, latch, id2, null);
        }

        static TimeoutTask newTaskWithException(RubyThread currentThread, IRubyObject timeout2, AtomicBoolean latch, IRubyObject exception2) {
            return new TimeoutTask(currentThread, timeout2, latch, null, exception2);
        }

        @Override
        public void run() {
            if (this.latch.compareAndSet(false, true)) {
                if (this.exception == null) {
                    this.raiseAnnonymous();
                } else {
                    this.raiseException();
                }
            }
        }

        private void raiseAnnonymous() {
            Ruby runtime = this.timeout.getRuntime();
            IRubyObject anonException = Timeout.getAnonymousException(this.timeout).newInstance(runtime.getCurrentContext(), runtime.newString("execution expired"), Block.NULL_BLOCK);
            anonException.getInternalVariables().setInternalVariable("__identifier__", this.id);
            this.currentThread.internalRaise(new IRubyObject[]{anonException});
        }

        private void raiseException() {
            Ruby runtime = this.timeout.getRuntime();
            this.currentThread.internalRaise(new IRubyObject[]{this.exception, runtime.newString("execution expired")});
        }
    }

    public static class TimeoutToplevel {
        @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE)
        public static IRubyObject timeout(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
            return Helpers.invoke(context, (IRubyObject)context.runtime.getModule("Timeout"), "timeout", args2, block);
        }
    }
}

