/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect.fields;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.logstash.Event;
import org.logstash.dissect.Delimiter;
import org.logstash.dissect.ValueResolver;

public interface Field {
    public static final int SKIP_ORDINAL_LOWEST = 0;
    public static final int NORMAL_ORDINAL_LOWER = 1;
    public static final int APPEND_ORDINAL_BASE = 100;
    public static final int INDIRECT_ORDINAL_HIGHER = 1000;
    public static final int MISSING_ORDINAL_HIGHEST = 100000;
    public static final Pattern SUFFIX_REGEX = Pattern.compile("(.+?)(/\\d{1,2}|->|/\\d{1,2}->|->/\\d{1,2})?$");
    public static final Pattern ORDINAL_REGEX = Pattern.compile("\\d+");
    public static final String GREEDY_SUFFIX = "->";

    public static String[] extractNameSuffix(String s) {
        String[] result = new String[]{s, ""};
        Matcher m = SUFFIX_REGEX.matcher(s);
        if (m.matches()) {
            result[0] = m.group(1);
            result[1] = m.group(2) == null ? "" : m.group(2);
        }
        return result;
    }

    public void append(Map<String, Object> var1, ValueResolver var2);

    public void append(Event var1, ValueResolver var2);

    public boolean saveable();

    public Delimiter nextDelimiter();

    public Delimiter previousDelimiter();

    public int ordinal();

    public String name();

    public int id();
}

