"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isValidRandomValue = exports.isValidThreshold = exports.MIN_THRESHOLD = exports.MAX_THRESHOLD = exports.INVALID_RANDOM_VALUE = exports.INVALID_THRESHOLD = void 0;
exports.INVALID_THRESHOLD = -1n;
exports.INVALID_RANDOM_VALUE = -1n;
const RANDOM_VALUE_BITS = 56n;
exports.MAX_THRESHOLD = 1n << RANDOM_VALUE_BITS; // 0% sampling
exports.MIN_THRESHOLD = 0n; // 100% sampling
const MAX_RANDOM_VALUE = exports.MAX_THRESHOLD - 1n;
function isValidThreshold(threshold) {
    return threshold >= exports.MIN_THRESHOLD && threshold <= exports.MAX_THRESHOLD;
}
exports.isValidThreshold = isValidThreshold;
function isValidRandomValue(randomValue) {
    return randomValue >= 0n && randomValue <= MAX_RANDOM_VALUE;
}
exports.isValidRandomValue = isValidRandomValue;
//# sourceMappingURL=util.js.map