"use strict";
/*
 * Copyright The OpenTelemetry Authors
 * Copyright (c) 2025, Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.OracleInstrumentation = void 0;
const instrumentation_1 = require("@opentelemetry/instrumentation");
const OracleTelemetryTraceHandler_1 = require("./OracleTelemetryTraceHandler");
/** @knipignore */
const version_1 = require("./version");
class OracleInstrumentation extends instrumentation_1.InstrumentationBase {
    _tmHandler;
    constructor(config = {}) {
        super(version_1.PACKAGE_NAME, version_1.PACKAGE_VERSION, config);
    }
    init() {
        const moduleOracleDB = new instrumentation_1.InstrumentationNodeModuleDefinition('oracledb', ['>= 6.7 < 7'], (moduleExports) => {
            if (!moduleExports) {
                return;
            }
            if (this._tmHandler) {
                // Already registered, so unregister it.
                moduleExports.traceHandler.setTraceInstance();
                this._tmHandler = null;
            }
            const config = this.getConfig();
            const thClass = (0, OracleTelemetryTraceHandler_1.getOracleTelemetryTraceHandlerClass)(moduleExports);
            if (thClass) {
                const obj = new thClass(() => this.tracer, config);
                obj.enable();
                // Register the instance with oracledb.
                moduleExports.traceHandler.setTraceInstance(obj);
                this._tmHandler = obj;
            }
            return moduleExports;
        }, moduleExports => {
            if (this._tmHandler) {
                moduleExports.traceHandler.setTraceInstance();
                this._tmHandler = null;
            }
        });
        return [moduleOracleDB];
    }
    setConfig(config = {}) {
        super.setConfig(config);
        // update the config in OracleTelemetryTraceHandler obj.
        this._tmHandler?.setInstrumentConfig(this._config);
    }
}
exports.OracleInstrumentation = OracleInstrumentation;
//# sourceMappingURL=instrumentation.js.map