"use strict";
/*
 * Copyright The OpenTelemetry Authors
 * Copyright (c) 2025, Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpanNames = void 0;
// Contains span names produced by instrumentation
// It lists the RPC names (suffix with _MSG like EXECUTE_MSG) and
// exported oracledb functions (like EXECUTE).
// These constants need to be in sync with what is generated by the
// 'oracledb' module.
var SpanNames;
(function (SpanNames) {
    SpanNames["CONNECT"] = "oracledb.getConnection";
    SpanNames["POOL_CONNECT"] = "oracledb.Pool.getConnection";
    SpanNames["POOL_CREATE"] = "oracledb.createPool";
    SpanNames["CONNECT_PROTOCOL_NEG"] = "oracledb.ProtocolMessage";
    SpanNames["CONNECT_DATATYPE_NEG"] = "oracledb.DataTypeMessage";
    SpanNames["CONNECT_AUTH_MSG"] = "oracledb.AuthMessage";
    SpanNames["CONNECT_FAST_AUTH"] = "oracledb.FastAuthMessage";
    SpanNames["EXECUTE_MSG"] = "oracledb.ExecuteMessage";
    SpanNames["EXECUTE"] = "oracledb.Connection.execute";
    SpanNames["EXECUTE_MANY"] = "oracledb.Connection.executeMany";
    SpanNames["LOGOFF_MSG"] = "oracledb.LogOffMessage";
    SpanNames["CONNECT_CLOSE"] = "oracledb.Connection.close";
    SpanNames["CREATE_LOB"] = "oracledb.Connection.createLob";
    SpanNames["LOB_MESSAGE"] = "oracledb.LobOpMessage";
    SpanNames["LOB_GETDATA"] = "oracledb.Lob.getData";
})(SpanNames = exports.SpanNames || (exports.SpanNames = {}));
//# sourceMappingURL=constants.js.map