var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// src/provider/provider.ts
import {
  ServerProviderStatus
} from "@openfeature/core";

// src/provider/no-op-provider.ts
var REASON_NO_OP = "No-op";
var NoopFeatureProvider = class {
  constructor() {
    this.metadata = {
      name: "No-op Provider"
    };
  }
  resolveBooleanEvaluation(_, defaultValue) {
    return this.noOp(defaultValue);
  }
  resolveStringEvaluation(_, defaultValue) {
    return this.noOp(defaultValue);
  }
  resolveNumberEvaluation(_, defaultValue) {
    return this.noOp(defaultValue);
  }
  resolveObjectEvaluation(_, defaultValue) {
    return this.noOp(defaultValue);
  }
  noOp(defaultValue) {
    return Promise.resolve({
      value: defaultValue,
      reason: REASON_NO_OP
    });
  }
};
var NOOP_PROVIDER = new NoopFeatureProvider();

// src/provider/in-memory-provider/in-memory-provider.ts
import {
  FlagNotFoundError,
  GeneralError,
  OpenFeatureError as OpenFeatureError2,
  StandardResolutionReasons,
  TypeMismatchError
} from "@openfeature/core";

// src/provider/in-memory-provider/variant-not-found-error.ts
import { ErrorCode, OpenFeatureError } from "@openfeature/core";
var VariantFoundError = class _VariantFoundError extends OpenFeatureError {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, _VariantFoundError.prototype);
    this.name = "VariantFoundError";
    this.code = ErrorCode.GENERAL;
  }
};

// src/provider/in-memory-provider/in-memory-provider.ts
var InMemoryProvider = class {
  constructor(flagConfiguration = {}) {
    this.events = new OpenFeatureEventEmitter();
    this.runsOn = "server";
    this.metadata = {
      name: "in-memory"
    };
    this._flagConfiguration = __spreadValues({}, flagConfiguration);
  }
  /**
   * Overwrites the configured flags.
   * @param { FlagConfiguration } flagConfiguration new flag configuration
   */
  putConfiguration(flagConfiguration) {
    const flagsChanged = Object.entries(flagConfiguration).filter(([key, value]) => this._flagConfiguration[key] !== value).map(([key]) => key);
    this._flagConfiguration = __spreadValues({}, flagConfiguration);
    this.events.emit(ServerProviderEvents.ConfigurationChanged, { flagsChanged });
  }
  resolveBooleanEvaluation(flagKey, defaultValue, context, logger) {
    return this.resolveFlagWithReason(flagKey, defaultValue, context, logger);
  }
  resolveNumberEvaluation(flagKey, defaultValue, context, logger) {
    return this.resolveFlagWithReason(flagKey, defaultValue, context, logger);
  }
  resolveStringEvaluation(flagKey, defaultValue, context, logger) {
    return __async(this, null, function* () {
      return this.resolveFlagWithReason(flagKey, defaultValue, context, logger);
    });
  }
  resolveObjectEvaluation(flagKey, defaultValue, context, logger) {
    return __async(this, null, function* () {
      return this.resolveFlagWithReason(flagKey, defaultValue, context, logger);
    });
  }
  resolveFlagWithReason(flagKey, defaultValue, ctx, logger) {
    return __async(this, null, function* () {
      try {
        const resolutionResult = this.lookupFlagValue(flagKey, defaultValue, ctx, logger);
        if (typeof (resolutionResult == null ? void 0 : resolutionResult.value) != typeof defaultValue) {
          throw new TypeMismatchError();
        }
        return resolutionResult;
      } catch (error) {
        if (!(error instanceof OpenFeatureError2)) {
          throw new GeneralError((error == null ? void 0 : error.message) || "unknown error");
        }
        throw error;
      }
    });
  }
  lookupFlagValue(flagKey, defaultValue, ctx, logger) {
    var _a;
    if (!(flagKey in this._flagConfiguration)) {
      const message = `no flag found with key ${flagKey}`;
      logger == null ? void 0 : logger.debug(message);
      throw new FlagNotFoundError(message);
    }
    const flagSpec = this._flagConfiguration[flagKey];
    if (flagSpec.disabled) {
      return { value: defaultValue, reason: StandardResolutionReasons.DISABLED };
    }
    const isContextEval = ctx && (flagSpec == null ? void 0 : flagSpec.contextEvaluator);
    const variant = isContextEval ? (_a = flagSpec.contextEvaluator) == null ? void 0 : _a.call(flagSpec, ctx) : flagSpec.defaultVariant;
    const value = variant && (flagSpec == null ? void 0 : flagSpec.variants[variant]);
    if (value === void 0) {
      const message = `no value associated with variant ${variant}`;
      logger == null ? void 0 : logger.error(message);
      throw new VariantFoundError(message);
    }
    return __spreadProps(__spreadValues({
      value
    }, variant && { variant }), {
      reason: isContextEval ? StandardResolutionReasons.TARGETING_MATCH : StandardResolutionReasons.STATIC
    });
  }
};

// src/provider/multi-provider/multi-provider.ts
import { DefaultLogger, ErrorCode as ErrorCode3, GeneralError as GeneralError4, StandardResolutionReasons as StandardResolutionReasons2 } from "@openfeature/core";

// src/events/open-feature-event-emitter.ts
import { GenericEventEmitter } from "@openfeature/core";
import { EventEmitter } from "node:events";
var OpenFeatureEventEmitter = class extends GenericEventEmitter {
  constructor() {
    super();
    this.eventEmitter = new EventEmitter({ captureRejections: true });
    this.eventEmitter.on("error", (err) => {
      var _a;
      (_a = this._logger) == null ? void 0 : _a.error("Error running event handler:", err);
    });
  }
};

// src/provider/multi-provider/errors.ts
import { GeneralError as GeneralError2, OpenFeatureError as OpenFeatureError3 } from "@openfeature/core";
var ErrorWithCode = class extends OpenFeatureError3 {
  constructor(code, message) {
    super(message);
    this.code = code;
  }
};
var AggregateError = class extends GeneralError2 {
  constructor(message, originalErrors) {
    super(message);
    this.originalErrors = originalErrors;
  }
};
var constructAggregateError = (providerErrors) => {
  const errorsWithSource = providerErrors.map(({ providerName, error }) => {
    return { source: providerName, error };
  }).flat();
  return new AggregateError(
    `Provider errors occurred: ${errorsWithSource[0].source}: ${errorsWithSource[0].error}`,
    errorsWithSource
  );
};
var throwAggregateErrorFromPromiseResults = (result, providerEntries) => {
  const errors = result.map((r, i) => {
    if (r.status === "rejected") {
      return { error: r.reason, providerName: providerEntries[i].name };
    }
    return null;
  }).filter((val) => Boolean(val));
  if (errors.length) {
    throw constructAggregateError(errors);
  }
};

// src/provider/multi-provider/hook-executor.ts
var HookExecutor = class {
  constructor(logger) {
    this.logger = logger;
  }
  beforeHooks(hooks, hookContext, hints) {
    return __async(this, null, function* () {
      var _a;
      for (const hook of hooks != null ? hooks : []) {
        Object.freeze(hookContext);
        Object.assign(hookContext.context, __spreadValues({}, yield (_a = hook == null ? void 0 : hook.before) == null ? void 0 : _a.call(hook, hookContext, Object.freeze(hints))));
      }
      return Object.freeze(hookContext.context);
    });
  }
  afterHooks(hooks, hookContext, evaluationDetails, hints) {
    return __async(this, null, function* () {
      var _a;
      for (const hook of hooks != null ? hooks : []) {
        yield (_a = hook == null ? void 0 : hook.after) == null ? void 0 : _a.call(hook, hookContext, evaluationDetails, hints);
      }
    });
  }
  errorHooks(hooks, hookContext, err, hints) {
    return __async(this, null, function* () {
      var _a;
      for (const hook of hooks != null ? hooks : []) {
        try {
          yield (_a = hook == null ? void 0 : hook.error) == null ? void 0 : _a.call(hook, hookContext, err, hints);
        } catch (err2) {
          this.logger.error(`Unhandled error during 'error' hook: ${err2}`);
          if (err2 instanceof Error) {
            this.logger.error(err2.stack);
          }
          this.logger.error(err2 == null ? void 0 : err2.stack);
        }
      }
    });
  }
  finallyHooks(hooks, hookContext, evaluationDetails, hints) {
    return __async(this, null, function* () {
      var _a;
      for (const hook of hooks != null ? hooks : []) {
        try {
          yield (_a = hook == null ? void 0 : hook.finally) == null ? void 0 : _a.call(hook, hookContext, evaluationDetails, hints);
        } catch (err) {
          this.logger.error(`Unhandled error during 'finally' hook: ${err}`);
          if (err instanceof Error) {
            this.logger.error(err.stack);
          }
          this.logger.error(err == null ? void 0 : err.stack);
        }
      }
    });
  }
};

// src/events/events.ts
import { ServerProviderEvents } from "@openfeature/core";

// src/provider/multi-provider/status-tracker.ts
var StatusTracker = class {
  constructor(events) {
    this.events = events;
    this.providerStatuses = {};
  }
  wrapEventHandler(providerEntry) {
    var _a, _b, _c, _d;
    const provider = providerEntry.provider;
    (_a = provider.events) == null ? void 0 : _a.addHandler(ServerProviderEvents.Error, (details) => {
      this.changeProviderStatus(providerEntry.name, ServerProviderStatus.ERROR, details);
    });
    (_b = provider.events) == null ? void 0 : _b.addHandler(ServerProviderEvents.Stale, (details) => {
      this.changeProviderStatus(providerEntry.name, ServerProviderStatus.STALE, details);
    });
    (_c = provider.events) == null ? void 0 : _c.addHandler(ServerProviderEvents.ConfigurationChanged, (details) => {
      this.events.emit(ServerProviderEvents.ConfigurationChanged, details);
    });
    (_d = provider.events) == null ? void 0 : _d.addHandler(ServerProviderEvents.Ready, (details) => {
      this.changeProviderStatus(providerEntry.name, ServerProviderStatus.READY, details);
    });
  }
  providerStatus(name) {
    return this.providerStatuses[name];
  }
  getStatusFromProviderStatuses() {
    const statuses = Object.values(this.providerStatuses);
    if (statuses.includes(ServerProviderStatus.FATAL)) {
      return ServerProviderStatus.FATAL;
    } else if (statuses.includes(ServerProviderStatus.NOT_READY)) {
      return ServerProviderStatus.NOT_READY;
    } else if (statuses.includes(ServerProviderStatus.ERROR)) {
      return ServerProviderStatus.ERROR;
    } else if (statuses.includes(ServerProviderStatus.STALE)) {
      return ServerProviderStatus.STALE;
    }
    return ServerProviderStatus.READY;
  }
  changeProviderStatus(name, status, details) {
    const currentStatus = this.getStatusFromProviderStatuses();
    this.providerStatuses[name] = status;
    const newStatus = this.getStatusFromProviderStatuses();
    if (currentStatus !== newStatus) {
      if (newStatus === ServerProviderStatus.FATAL || newStatus === ServerProviderStatus.ERROR) {
        this.events.emit(ServerProviderEvents.Error, details);
      } else if (newStatus === ServerProviderStatus.STALE) {
        this.events.emit(ServerProviderEvents.Stale, details);
      } else if (newStatus === ServerProviderStatus.READY) {
        this.events.emit(ServerProviderEvents.Ready, details);
      }
    }
  }
};

// src/provider/multi-provider/strategies/base-evaluation-strategy.ts
var BaseEvaluationStrategy = class {
  constructor() {
    this.runMode = "sequential";
  }
  shouldEvaluateThisProvider(strategyContext, _evalContext) {
    if (strategyContext.providerStatus === ServerProviderStatus.NOT_READY || strategyContext.providerStatus === ServerProviderStatus.FATAL) {
      return false;
    }
    return true;
  }
  shouldEvaluateNextProvider(_strategyContext, _context, _result) {
    return true;
  }
  shouldTrackWithThisProvider(strategyContext, _context, _trackingEventName, _trackingEventDetails) {
    if (strategyContext.providerStatus === ServerProviderStatus.NOT_READY || strategyContext.providerStatus === ServerProviderStatus.FATAL) {
      return false;
    }
    return true;
  }
  hasError(resolution) {
    return "thrownError" in resolution || !!resolution.details.errorCode;
  }
  hasErrorWithCode(resolution, code) {
    var _a;
    return "thrownError" in resolution ? ((_a = resolution.thrownError) == null ? void 0 : _a.code) === code : resolution.details.errorCode === code;
  }
  collectProviderErrors(resolutions) {
    var _a;
    const errors = [];
    for (const resolution of resolutions) {
      if ("thrownError" in resolution) {
        errors.push({ providerName: resolution.providerName, error: resolution.thrownError });
      } else if (resolution.details.errorCode) {
        errors.push({
          providerName: resolution.providerName,
          error: new ErrorWithCode(resolution.details.errorCode, (_a = resolution.details.errorMessage) != null ? _a : "unknown error")
        });
      }
    }
    return { errors };
  }
  resolutionToFinalResult(resolution) {
    return { details: resolution.details, provider: resolution.provider, providerName: resolution.providerName };
  }
};

// src/provider/multi-provider/strategies/first-match-strategy.ts
import { ErrorCode as ErrorCode2 } from "@openfeature/core";
var FirstMatchStrategy = class extends BaseEvaluationStrategy {
  shouldEvaluateNextProvider(strategyContext, context, result) {
    if (this.hasErrorWithCode(result, ErrorCode2.FLAG_NOT_FOUND)) {
      return true;
    }
    if (this.hasError(result)) {
      return false;
    }
    return false;
  }
  determineFinalResult(strategyContext, context, resolutions) {
    const finalResolution = resolutions[resolutions.length - 1];
    if (this.hasError(finalResolution)) {
      return this.collectProviderErrors(resolutions);
    }
    return this.resolutionToFinalResult(finalResolution);
  }
};

// src/provider/multi-provider/strategies/first-successful-strategy.ts
var FirstSuccessfulStrategy = class extends BaseEvaluationStrategy {
  shouldEvaluateNextProvider(strategyContext, context, result) {
    return this.hasError(result);
  }
  determineFinalResult(strategyContext, context, resolutions) {
    const finalResolution = resolutions[resolutions.length - 1];
    if (this.hasError(finalResolution)) {
      return this.collectProviderErrors(resolutions);
    }
    return this.resolutionToFinalResult(finalResolution);
  }
};

// src/provider/multi-provider/strategies/comparison-strategy.ts
import { GeneralError as GeneralError3 } from "@openfeature/core";
var ComparisonStrategy = class extends BaseEvaluationStrategy {
  constructor(fallbackProvider, onMismatch) {
    super();
    this.fallbackProvider = fallbackProvider;
    this.onMismatch = onMismatch;
    this.runMode = "parallel";
  }
  determineFinalResult(strategyContext, context, resolutions) {
    var _a;
    let value;
    let fallbackResolution;
    let finalResolution;
    let mismatch = false;
    for (const [i, resolution] of resolutions.entries()) {
      if (this.hasError(resolution)) {
        return this.collectProviderErrors(resolutions);
      }
      if (resolution.provider === this.fallbackProvider) {
        fallbackResolution = resolution;
      }
      if (i === 0) {
        finalResolution = resolution;
      }
      if (typeof value !== "undefined" && value !== resolution.details.value) {
        mismatch = true;
      } else {
        value = resolution.details.value;
      }
    }
    if (!fallbackResolution) {
      throw new GeneralError3("Fallback provider not found in resolution results");
    }
    if (!finalResolution) {
      throw new GeneralError3("Final resolution not found in resolution results");
    }
    if (mismatch) {
      (_a = this.onMismatch) == null ? void 0 : _a.call(this, resolutions);
      return {
        details: fallbackResolution.details,
        provider: fallbackResolution.provider
      };
    }
    return this.resolutionToFinalResult(finalResolution);
  }
};

// src/provider/multi-provider/multi-provider.ts
var MultiProvider = class _MultiProvider {
  constructor(constructorProviders, evaluationStrategy = new FirstMatchStrategy(), logger = new DefaultLogger()) {
    this.constructorProviders = constructorProviders;
    this.evaluationStrategy = evaluationStrategy;
    this.logger = logger;
    this.runsOn = "server";
    this.events = new OpenFeatureEventEmitter();
    this.hookContexts = /* @__PURE__ */ new WeakMap();
    this.hookHints = /* @__PURE__ */ new WeakMap();
    this.providerEntries = [];
    this.providerEntriesByName = {};
    this.statusTracker = new StatusTracker(this.events);
    this.hookExecutor = new HookExecutor(this.logger);
    this.registerProviders(constructorProviders);
    const aggregateMetadata = Object.keys(this.providerEntriesByName).reduce((acc, name) => {
      return __spreadProps(__spreadValues({}, acc), { [name]: this.providerEntriesByName[name].provider.metadata });
    }, {});
    this.metadata = __spreadProps(__spreadValues({}, aggregateMetadata), {
      name: _MultiProvider.name
    });
  }
  registerProviders(constructorProviders) {
    var _a, _b;
    const providersByName = {};
    for (const constructorProvider of constructorProviders) {
      const providerName = constructorProvider.provider.metadata.name;
      const candidateName = (_a = constructorProvider.name) != null ? _a : providerName;
      if (constructorProvider.name && providersByName[constructorProvider.name]) {
        throw new Error("Provider names must be unique");
      }
      (_b = providersByName[candidateName]) != null ? _b : providersByName[candidateName] = [];
      providersByName[candidateName].push(constructorProvider.provider);
    }
    for (const name of Object.keys(providersByName)) {
      const useIndexedNames = providersByName[name].length > 1;
      for (let i = 0; i < providersByName[name].length; i++) {
        const indexedName = useIndexedNames ? `${name}-${i + 1}` : name;
        this.providerEntriesByName[indexedName] = { provider: providersByName[name][i], name: indexedName };
        this.providerEntries.push(this.providerEntriesByName[indexedName]);
        this.statusTracker.wrapEventHandler(this.providerEntriesByName[indexedName]);
      }
    }
    Object.freeze(this.providerEntries);
    Object.freeze(this.providerEntriesByName);
  }
  initialize(context) {
    return __async(this, null, function* () {
      const result = yield Promise.allSettled(
        this.providerEntries.map((provider) => {
          var _a, _b;
          return (_b = (_a = provider.provider).initialize) == null ? void 0 : _b.call(_a, context);
        })
      );
      throwAggregateErrorFromPromiseResults(result, this.providerEntries);
    });
  }
  onClose() {
    return __async(this, null, function* () {
      const result = yield Promise.allSettled(this.providerEntries.map((provider) => {
        var _a, _b;
        return (_b = (_a = provider.provider).onClose) == null ? void 0 : _b.call(_a);
      }));
      throwAggregateErrorFromPromiseResults(result, this.providerEntries);
    });
  }
  resolveBooleanEvaluation(flagKey, defaultValue, context) {
    return this.flagResolutionProxy(flagKey, "boolean", defaultValue, context);
  }
  resolveStringEvaluation(flagKey, defaultValue, context) {
    return this.flagResolutionProxy(flagKey, "string", defaultValue, context);
  }
  resolveNumberEvaluation(flagKey, defaultValue, context) {
    return this.flagResolutionProxy(flagKey, "number", defaultValue, context);
  }
  resolveObjectEvaluation(flagKey, defaultValue, context) {
    return this.flagResolutionProxy(flagKey, "object", defaultValue, context);
  }
  flagResolutionProxy(flagKey, flagType, defaultValue, context) {
    return __async(this, null, function* () {
      var _a;
      const hookContext = this.hookContexts.get(context);
      const hookHints = this.hookHints.get(context);
      if (!hookContext || !hookHints) {
        throw new GeneralError4("Hook context not available for evaluation");
      }
      const tasks = [];
      for (const providerEntry of this.providerEntries) {
        const task = this.evaluateProviderEntry(
          flagKey,
          flagType,
          defaultValue,
          providerEntry,
          hookContext,
          hookHints,
          context
        );
        tasks.push(task);
        if (this.evaluationStrategy.runMode === "sequential") {
          const [shouldEvaluateNext] = yield task;
          if (!shouldEvaluateNext) {
            break;
          }
        }
      }
      const results = yield Promise.all(tasks);
      const resolutions = results.map(([, resolution]) => resolution).filter((r) => Boolean(r));
      const finalResult = this.evaluationStrategy.determineFinalResult({ flagKey, flagType }, context, resolutions);
      if ((_a = finalResult.errors) == null ? void 0 : _a.length) {
        throw constructAggregateError(finalResult.errors);
      }
      if (!finalResult.details) {
        throw new GeneralError4("No result was returned from any provider");
      }
      return finalResult.details;
    });
  }
  evaluateProviderEntry(flagKey, flagType, defaultValue, providerEntry, hookContext, hookHints, context) {
    return __async(this, null, function* () {
      let evaluationResult = void 0;
      const provider = providerEntry.provider;
      const strategyContext = {
        flagKey,
        flagType,
        provider,
        providerName: providerEntry.name,
        providerStatus: this.statusTracker.providerStatus(providerEntry.name)
      };
      if (!this.evaluationStrategy.shouldEvaluateThisProvider(strategyContext, context)) {
        return [true, null];
      }
      let resolution;
      try {
        evaluationResult = yield this.evaluateProviderAndHooks(flagKey, defaultValue, provider, hookContext, hookHints);
        resolution = {
          details: evaluationResult,
          provider,
          providerName: providerEntry.name
        };
      } catch (error) {
        resolution = {
          thrownError: error,
          provider,
          providerName: providerEntry.name
        };
      }
      return [
        this.evaluationStrategy.runMode === "sequential" ? this.evaluationStrategy.shouldEvaluateNextProvider(strategyContext, context, resolution) : true,
        resolution
      ];
    });
  }
  evaluateProviderAndHooks(flagKey, defaultValue, provider, hookContext, hookHints) {
    return __async(this, null, function* () {
      var _a;
      let providerContext = void 0;
      let evaluationDetails;
      const hookContextCopy = __spreadProps(__spreadValues({}, hookContext), { context: __spreadValues({}, hookContext.context) });
      try {
        providerContext = yield this.hookExecutor.beforeHooks(provider.hooks, hookContextCopy, hookHints);
        const resolutionDetails = yield this.callProviderResolve(
          provider,
          flagKey,
          defaultValue,
          providerContext || {}
        );
        evaluationDetails = __spreadProps(__spreadValues({}, resolutionDetails), {
          flagMetadata: Object.freeze((_a = resolutionDetails.flagMetadata) != null ? _a : {}),
          flagKey
        });
        yield this.hookExecutor.afterHooks(provider.hooks, hookContextCopy, evaluationDetails, hookHints);
      } catch (error) {
        yield this.hookExecutor.errorHooks(provider.hooks, hookContextCopy, error, hookHints);
        evaluationDetails = this.getErrorEvaluationDetails(flagKey, defaultValue, error);
      }
      yield this.hookExecutor.finallyHooks(provider.hooks, hookContextCopy, evaluationDetails, hookHints);
      return evaluationDetails;
    });
  }
  callProviderResolve(provider, flagKey, defaultValue, context) {
    return __async(this, null, function* () {
      switch (typeof defaultValue) {
        case "string":
          return yield provider.resolveStringEvaluation(flagKey, defaultValue, context, this.logger);
        case "number":
          return yield provider.resolveNumberEvaluation(flagKey, defaultValue, context, this.logger);
        case "object":
          return yield provider.resolveObjectEvaluation(flagKey, defaultValue, context, this.logger);
        case "boolean":
          return yield provider.resolveBooleanEvaluation(flagKey, defaultValue, context, this.logger);
        default:
          throw new GeneralError4("Invalid flag evaluation type");
      }
    });
  }
  get hooks() {
    return [
      {
        before: (hookContext, hints) => __async(this, null, function* () {
          this.hookContexts.set(hookContext.context, hookContext);
          this.hookHints.set(hookContext.context, hints != null ? hints : {});
          return hookContext.context;
        })
      }
    ];
  }
  track(trackingEventName, context, trackingEventDetails) {
    var _a, _b;
    for (const providerEntry of this.providerEntries) {
      if (!providerEntry.provider.track) {
        continue;
      }
      const strategyContext = {
        provider: providerEntry.provider,
        providerName: providerEntry.name,
        providerStatus: this.statusTracker.providerStatus(providerEntry.name)
      };
      if (this.evaluationStrategy.shouldTrackWithThisProvider(
        strategyContext,
        context,
        trackingEventName,
        trackingEventDetails
      )) {
        try {
          (_b = (_a = providerEntry.provider).track) == null ? void 0 : _b.call(_a, trackingEventName, context, trackingEventDetails);
        } catch (error) {
          this.logger.error(
            `Error tracking event "${trackingEventName}" with provider "${providerEntry.name}":`,
            error
          );
        }
      }
    }
  }
  getErrorEvaluationDetails(flagKey, defaultValue, err, flagMetadata = {}) {
    const errorMessage = err == null ? void 0 : err.message;
    const errorCode = (err == null ? void 0 : err.code) || ErrorCode3.GENERAL;
    return {
      errorCode,
      errorMessage,
      value: defaultValue,
      reason: StandardResolutionReasons2.ERROR,
      flagMetadata: Object.freeze(flagMetadata),
      flagKey
    };
  }
};

// src/open-feature.ts
import {
  OpenFeatureCommonAPI,
  ProviderWrapper,
  objectOrUndefined,
  stringOrUndefined
} from "@openfeature/core";

// src/client/internal/open-feature-client.ts
import {
  ErrorCode as ErrorCode4,
  ProviderFatalError,
  ProviderNotReadyError,
  SafeLogger,
  StandardResolutionReasons as StandardResolutionReasons3,
  instantiateErrorByErrorCode,
  statusMatchesEvent,
  MapHookData
} from "@openfeature/core";
var OpenFeatureClient = class {
  constructor(providerAccessor, providerStatusAccessor, emitterAccessor, apiContextAccessor, apiHooksAccessor, transactionContextAccessor, globalLogger, options, context = {}) {
    this.providerAccessor = providerAccessor;
    this.providerStatusAccessor = providerStatusAccessor;
    this.emitterAccessor = emitterAccessor;
    this.apiContextAccessor = apiContextAccessor;
    this.apiHooksAccessor = apiHooksAccessor;
    this.transactionContextAccessor = transactionContextAccessor;
    this.globalLogger = globalLogger;
    this.options = options;
    this._hooks = [];
    this._context = context;
  }
  get metadata() {
    var _a, _b;
    return {
      // Use domain if name is not provided
      name: (_a = this.options.domain) != null ? _a : this.options.name,
      domain: (_b = this.options.domain) != null ? _b : this.options.name,
      version: this.options.version,
      providerMetadata: this.providerAccessor().metadata
    };
  }
  get providerStatus() {
    return this.providerStatusAccessor();
  }
  addHandler(eventType, handler, options) {
    var _a;
    this.emitterAccessor().addHandler(eventType, handler);
    const shouldRunNow = statusMatchesEvent(eventType, this._providerStatus);
    if (shouldRunNow) {
      try {
        handler({
          clientName: this.metadata.name,
          domain: this.metadata.domain,
          providerName: this._provider.metadata.name
        });
      } catch (err) {
        (_a = this._logger) == null ? void 0 : _a.error("Error running event handler:", err);
      }
    }
    if ((options == null ? void 0 : options.signal) && typeof options.signal.addEventListener === "function") {
      options.signal.addEventListener("abort", () => {
        this.removeHandler(eventType, handler);
      });
    }
  }
  removeHandler(eventType, handler) {
    this.emitterAccessor().removeHandler(eventType, handler);
  }
  getHandlers(eventType) {
    return this.emitterAccessor().getHandlers(eventType);
  }
  setLogger(logger) {
    this._clientLogger = new SafeLogger(logger);
    return this;
  }
  setContext(context) {
    this._context = context;
    return this;
  }
  getContext() {
    return this._context;
  }
  addHooks(...hooks) {
    this._hooks = [...this._hooks, ...hooks];
    return this;
  }
  getHooks() {
    return this._hooks;
  }
  clearHooks() {
    this._hooks = [];
    return this;
  }
  getBooleanValue(flagKey, defaultValue, context, options) {
    return __async(this, null, function* () {
      return (yield this.getBooleanDetails(flagKey, defaultValue, context, options)).value;
    });
  }
  getBooleanDetails(flagKey, defaultValue, context, options) {
    return this.evaluate(
      flagKey,
      this._provider.resolveBooleanEvaluation,
      defaultValue,
      "boolean",
      context,
      options
    );
  }
  getStringValue(flagKey, defaultValue, context, options) {
    return __async(this, null, function* () {
      return (yield this.getStringDetails(flagKey, defaultValue, context, options)).value;
    });
  }
  getStringDetails(flagKey, defaultValue, context, options) {
    return this.evaluate(
      flagKey,
      // this isolates providers from our restricted string generic argument.
      this._provider.resolveStringEvaluation,
      defaultValue,
      "string",
      context,
      options
    );
  }
  getNumberValue(flagKey, defaultValue, context, options) {
    return __async(this, null, function* () {
      return (yield this.getNumberDetails(flagKey, defaultValue, context, options)).value;
    });
  }
  getNumberDetails(flagKey, defaultValue, context, options) {
    return this.evaluate(
      flagKey,
      // this isolates providers from our restricted number generic argument.
      this._provider.resolveNumberEvaluation,
      defaultValue,
      "number",
      context,
      options
    );
  }
  getObjectValue(flagKey, defaultValue, context, options) {
    return __async(this, null, function* () {
      return (yield this.getObjectDetails(flagKey, defaultValue, context, options)).value;
    });
  }
  getObjectDetails(flagKey, defaultValue, context, options) {
    return this.evaluate(flagKey, this._provider.resolveObjectEvaluation, defaultValue, "object", context, options);
  }
  track(occurrenceKey, context = {}, occurrenceDetails = {}) {
    var _a, _b;
    try {
      this.shortCircuitIfNotReady();
      if (typeof this._provider.track === "function") {
        const frozenContext = Object.freeze(this.mergeContexts(context));
        return (_b = (_a = this._provider).track) == null ? void 0 : _b.call(_a, occurrenceKey, frozenContext, occurrenceDetails);
      } else {
        this._logger.debug("Provider does not support the track function; will no-op.");
      }
    } catch (err) {
      this._logger.debug("Error recording tracking event.", err);
    }
  }
  evaluate(_0, _1, _2, _3) {
    return __async(this, arguments, function* (flagKey, resolver, defaultValue, flagType, invocationContext = {}, options = {}) {
      var _a;
      const allHooks = [
        ...this.apiHooksAccessor(),
        ...this.getHooks(),
        ...options.hooks || [],
        ...this._provider.hooks || []
      ];
      const allHooksReversed = [...allHooks].reverse();
      const mergedContext = this.mergeContexts(invocationContext);
      const hookContexts = allHooksReversed.map(
        () => Object.freeze({
          flagKey,
          defaultValue,
          flagValueType: flagType,
          clientMetadata: this.metadata,
          providerMetadata: this._provider.metadata,
          context: mergedContext,
          logger: this._logger,
          hookData: new MapHookData()
        })
      );
      let evaluationDetails;
      try {
        const frozenContext = yield this.beforeHooks(allHooks, hookContexts, mergedContext, options);
        this.shortCircuitIfNotReady();
        const resolution = yield resolver.call(this._provider, flagKey, defaultValue, frozenContext, this._logger);
        const resolutionDetails = __spreadProps(__spreadValues({}, resolution), {
          flagMetadata: Object.freeze((_a = resolution.flagMetadata) != null ? _a : {}),
          flagKey
        });
        if (resolutionDetails.errorCode) {
          const err = instantiateErrorByErrorCode(resolutionDetails.errorCode, resolutionDetails.errorMessage);
          yield this.errorHooks(allHooksReversed, hookContexts, err, options);
          evaluationDetails = this.getErrorEvaluationDetails(flagKey, defaultValue, err, resolutionDetails.flagMetadata);
        } else {
          yield this.afterHooks(allHooksReversed, hookContexts, resolutionDetails, options);
          evaluationDetails = resolutionDetails;
        }
      } catch (err) {
        yield this.errorHooks(allHooksReversed, hookContexts, err, options);
        evaluationDetails = this.getErrorEvaluationDetails(flagKey, defaultValue, err);
      }
      yield this.finallyHooks(allHooksReversed, hookContexts, evaluationDetails, options);
      return evaluationDetails;
    });
  }
  beforeHooks(hooks, hookContexts, mergedContext, options) {
    return __async(this, null, function* () {
      var _a;
      const accumulatedContext = mergedContext;
      for (const [index, hook] of hooks.entries()) {
        const hookContextIndex = hooks.length - 1 - index;
        const hookContext = hookContexts[hookContextIndex];
        Object.assign(hookContext.context, accumulatedContext);
        const hookResult = yield (_a = hook == null ? void 0 : hook.before) == null ? void 0 : _a.call(hook, hookContext, Object.freeze(options.hookHints));
        if (hookResult) {
          Object.assign(accumulatedContext, hookResult);
          for (let i = 0; i < hooks.length; i++) {
            Object.assign(hookContexts[hookContextIndex].context, accumulatedContext);
          }
        }
      }
      return Object.freeze(accumulatedContext);
    });
  }
  afterHooks(hooks, hookContexts, evaluationDetails, options) {
    return __async(this, null, function* () {
      var _a;
      for (const [index, hook] of hooks.entries()) {
        const hookContext = hookContexts[index];
        yield (_a = hook == null ? void 0 : hook.after) == null ? void 0 : _a.call(hook, hookContext, evaluationDetails, options.hookHints);
      }
    });
  }
  errorHooks(hooks, hookContexts, err, options) {
    return __async(this, null, function* () {
      var _a;
      for (const [index, hook] of hooks.entries()) {
        try {
          const hookContext = hookContexts[index];
          yield (_a = hook == null ? void 0 : hook.error) == null ? void 0 : _a.call(hook, hookContext, err, options.hookHints);
        } catch (err2) {
          this._logger.error(`Unhandled error during 'error' hook: ${err2}`);
          if (err2 instanceof Error) {
            this._logger.error(err2.stack);
          }
          this._logger.error(err2 == null ? void 0 : err2.stack);
        }
      }
    });
  }
  finallyHooks(hooks, hookContexts, evaluationDetails, options) {
    return __async(this, null, function* () {
      var _a;
      for (const [index, hook] of hooks.entries()) {
        try {
          const hookContext = hookContexts[index];
          yield (_a = hook == null ? void 0 : hook.finally) == null ? void 0 : _a.call(hook, hookContext, evaluationDetails, options.hookHints);
        } catch (err) {
          this._logger.error(`Unhandled error during 'finally' hook: ${err}`);
          if (err instanceof Error) {
            this._logger.error(err.stack);
          }
          this._logger.error(err == null ? void 0 : err.stack);
        }
      }
    });
  }
  get _provider() {
    return this.providerAccessor();
  }
  get _providerStatus() {
    return this.providerStatusAccessor();
  }
  get _logger() {
    return this._clientLogger || this.globalLogger();
  }
  mergeContexts(invocationContext) {
    return __spreadValues(__spreadValues(__spreadValues(__spreadValues({}, this.apiContextAccessor()), this.transactionContextAccessor()), this._context), invocationContext);
  }
  shortCircuitIfNotReady() {
    if (this.providerStatus === ServerProviderStatus.NOT_READY) {
      throw new ProviderNotReadyError("provider has not yet initialized");
    } else if (this.providerStatus === ServerProviderStatus.FATAL) {
      throw new ProviderFatalError("provider is in an irrecoverable error state");
    }
  }
  getErrorEvaluationDetails(flagKey, defaultValue, err, flagMetadata = {}) {
    const errorMessage = err == null ? void 0 : err.message;
    const errorCode = (err == null ? void 0 : err.code) || ErrorCode4.GENERAL;
    return {
      errorCode,
      errorMessage,
      value: defaultValue,
      reason: StandardResolutionReasons3.ERROR,
      flagMetadata: Object.freeze(flagMetadata),
      flagKey
    };
  }
};

// src/transaction-context/no-op-transaction-context-propagator.ts
var NoopTransactionContextPropagator = class {
  getTransactionContext() {
    return {};
  }
  setTransactionContext(_, callback, ...args) {
    callback(...args);
  }
};
var NOOP_TRANSACTION_CONTEXT_PROPAGATOR = new NoopTransactionContextPropagator();

// src/transaction-context/async-local-storage-transaction-context-propagator.ts
import { AsyncLocalStorage } from "async_hooks";
var AsyncLocalStorageTransactionContextPropagator = class {
  constructor() {
    this.asyncLocalStorage = new AsyncLocalStorage();
  }
  getTransactionContext() {
    var _a;
    return (_a = this.asyncLocalStorage.getStore()) != null ? _a : {};
  }
  setTransactionContext(transactionContext, callback, ...args) {
    this.asyncLocalStorage.run(transactionContext, callback, ...args);
  }
};

// src/open-feature.ts
var GLOBAL_OPENFEATURE_API_KEY = Symbol.for("@openfeature/js-sdk/api");
var _globalThis = globalThis;
var OpenFeatureAPI = class _OpenFeatureAPI extends OpenFeatureCommonAPI {
  constructor() {
    super("server");
    this._statusEnumType = ServerProviderStatus;
    this._apiEmitter = new OpenFeatureEventEmitter();
    this._defaultProvider = new ProviderWrapper(
      NOOP_PROVIDER,
      ServerProviderStatus.NOT_READY,
      this._statusEnumType
    );
    this._domainScopedProviders = /* @__PURE__ */ new Map();
    this._createEventEmitter = () => new OpenFeatureEventEmitter();
    this._transactionContextPropagator = NOOP_TRANSACTION_CONTEXT_PROPAGATOR;
  }
  /**
   * Gets a singleton instance of the OpenFeature API.
   * @ignore
   * @returns {OpenFeatureAPI} OpenFeature API
   */
  static getInstance() {
    const globalApi = _globalThis[GLOBAL_OPENFEATURE_API_KEY];
    if (globalApi) {
      return globalApi;
    }
    const instance = new _OpenFeatureAPI();
    _globalThis[GLOBAL_OPENFEATURE_API_KEY] = instance;
    return instance;
  }
  getProviderStatus(domain) {
    var _a, _b;
    if (!domain) {
      return this._defaultProvider.status;
    }
    return (_b = (_a = this._domainScopedProviders.get(domain)) == null ? void 0 : _a.status) != null ? _b : this._defaultProvider.status;
  }
  setProviderAndWait(domainOrProvider, providerOrUndefined) {
    return __async(this, null, function* () {
      const domain = stringOrUndefined(domainOrProvider);
      const provider = domain ? objectOrUndefined(providerOrUndefined) : objectOrUndefined(domainOrProvider);
      yield this.setAwaitableProvider(domain, provider);
    });
  }
  setProvider(clientOrProvider, providerOrUndefined) {
    const domain = stringOrUndefined(clientOrProvider);
    const provider = domain ? objectOrUndefined(providerOrUndefined) : objectOrUndefined(clientOrProvider);
    const maybePromise = this.setAwaitableProvider(domain, provider);
    Promise.resolve(maybePromise).catch((err) => {
      this._logger.error("Error during provider initialization:", err);
    });
    return this;
  }
  getProvider(domain) {
    return this.getProviderForClient(domain);
  }
  setContext(context) {
    this._context = context;
    return this;
  }
  getContext() {
    return this._context;
  }
  getClient(domainOrContext, versionOrContext, contextOrUndefined) {
    var _a, _b;
    const domain = stringOrUndefined(domainOrContext);
    const version = stringOrUndefined(versionOrContext);
    const context = (_b = (_a = objectOrUndefined(domainOrContext)) != null ? _a : objectOrUndefined(versionOrContext)) != null ? _b : objectOrUndefined(contextOrUndefined);
    return new OpenFeatureClient(
      () => this.getProviderForClient(domain),
      () => this.getProviderStatus(domain),
      () => this.buildAndCacheEventEmitterForClient(domain),
      () => this.getContext(),
      () => this.getHooks(),
      () => this.getTransactionContext(),
      () => this._logger,
      { domain, version },
      context
    );
  }
  /**
   * Clears all registered providers and resets the default provider.
   * @returns {Promise<void>}
   */
  clearProviders() {
    return super.clearProvidersAndSetDefault(NOOP_PROVIDER);
  }
  setTransactionContextPropagator(transactionContextPropagator) {
    const baseMessage = "Invalid TransactionContextPropagator, will not be set: ";
    if (typeof (transactionContextPropagator == null ? void 0 : transactionContextPropagator.getTransactionContext) !== "function") {
      this._logger.error(`${baseMessage}: getTransactionContext is not a function.`);
    } else if (typeof (transactionContextPropagator == null ? void 0 : transactionContextPropagator.setTransactionContext) !== "function") {
      this._logger.error(`${baseMessage}: setTransactionContext is not a function.`);
    } else {
      this._transactionContextPropagator = transactionContextPropagator;
    }
    return this;
  }
  setTransactionContext(transactionContext, callback, ...args) {
    this._transactionContextPropagator.setTransactionContext(transactionContext, callback, ...args);
  }
  getTransactionContext() {
    try {
      return this._transactionContextPropagator.getTransactionContext();
    } catch (err) {
      const error = err;
      this._logger.error(`Error getting transaction context: ${error == null ? void 0 : error.message}, returning empty context.`);
      this._logger.error(error == null ? void 0 : error.stack);
      return {};
    }
  }
};
var OpenFeature = OpenFeatureAPI.getInstance();

// src/index.ts
export * from "@openfeature/core";
export {
  AggregateError,
  AsyncLocalStorageTransactionContextPropagator,
  BaseEvaluationStrategy,
  ComparisonStrategy,
  ErrorWithCode,
  FirstMatchStrategy,
  FirstSuccessfulStrategy,
  InMemoryProvider,
  MultiProvider,
  NOOP_PROVIDER,
  NOOP_TRANSACTION_CONTEXT_PROPAGATOR,
  OpenFeature,
  OpenFeatureAPI,
  OpenFeatureEventEmitter,
  ServerProviderEvents as ProviderEvents,
  ServerProviderStatus as ProviderStatus,
  constructAggregateError,
  throwAggregateErrorFromPromiseResults
};
//# sourceMappingURL=index.js.map
