"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class NullEventSource {
    constructor(url, options) {
        this.handlers = {};
        this.closed = false;
        this.url = url;
        this.options = options;
    }
    addEventListener(type, listener) {
        this.handlers[type] = listener;
    }
    close() {
        this.closed = true;
    }
    simulateError(error) {
        const shouldRetry = this.options.errorFilter(error);
        if (!shouldRetry) {
            this.closed = true;
        }
    }
}
exports.default = NullEventSource;
//# sourceMappingURL=NullEventSource.js.map