"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIsNarrowSchema = createIsNarrowSchema;
exports.isSchema = isSchema;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createIsNarrowSchema(_base, narrow) {
  return value => {
    return isSchema(narrow, value);
  };
}
function isSchema(schema, value) {
  return schema.safeParse(value).success;
}