"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBooleanFromString = exports.BooleanFromString = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var z = _interopRequireWildcard(require("@kbn/zod"));
var _kbn_zod_type = require("./kbn_zod_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * This is a helper schema to convert a boolean string ("true" or "false") to a
 * boolean. Useful for processing query params.
 *
 * Accepts "true" or "false" as strings, or a boolean.
 */
class KbnZodBooleanFromString extends z.ZodUnion {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "kbnTypeName", _kbn_zod_type.KbnZodTypes.BooleanFromString);
  }
  static create() {
    return new KbnZodBooleanFromString({
      typeName: z.ZodFirstPartyTypeKind.ZodUnion,
      options: [z.enum(['true', 'false']), z.boolean()]
    }).describe("A boolean value, which can be 'true' or 'false' as string or a native boolean.");
  }
  _parse(input) {
    const result = super._parse(input); // Use ZodUnion's default parsing

    if (z.isValid(result)) {
      const value = result.value;
      return {
        status: 'valid',
        value: value === 'true' ? true : value === 'false' ? false : value
      };
    }
    return result;
  }
}
const BooleanFromString = exports.BooleanFromString = KbnZodBooleanFromString.create();
const isBooleanFromString = val => {
  return val.kbnTypeName === _kbn_zod_type.KbnZodTypes.BooleanFromString;
};
exports.isBooleanFromString = isBooleanFromString;