"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBuiltInStepType = void 0;
exports.isDangerousStatus = isDangerousStatus;
exports.isIfStep = exports.isHttpStep = exports.isForeachStep = exports.isElasticsearchStep = void 0;
exports.isInProgressStatus = isInProgressStatus;
exports.isWaitStep = exports.isTriggerType = exports.isParallelStep = exports.isMergeStep = exports.isKibanaStep = void 0;
exports.transformWorkflowYamlJsontoEsWorkflow = transformWorkflowYamlJsontoEsWorkflow;
var _schema = require("../spec/schema");
var _v = require("./v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformWorkflowYamlJsontoEsWorkflow(workflowDefinition) {
  var _workflowDefinition$t;
  // TODO: handle merge, if, foreach, etc.

  return {
    name: workflowDefinition.name,
    description: workflowDefinition.description,
    tags: (_workflowDefinition$t = workflowDefinition.tags) !== null && _workflowDefinition$t !== void 0 ? _workflowDefinition$t : [],
    enabled: workflowDefinition.enabled,
    definition: workflowDefinition,
    deleted_at: null,
    valid: true
  };
}
function isInProgressStatus(status) {
  return status === _v.ExecutionStatus.RUNNING || status === _v.ExecutionStatus.PENDING || status === _v.ExecutionStatus.WAITING || status === _v.ExecutionStatus.WAITING_FOR_INPUT;
}
function isDangerousStatus(status) {
  return status === _v.ExecutionStatus.FAILED || status === _v.ExecutionStatus.CANCELLED;
}

// Type guards for steps types
const isWaitStep = step => step.type === 'wait';
exports.isWaitStep = isWaitStep;
const isHttpStep = step => step.type === 'http';
exports.isHttpStep = isHttpStep;
const isElasticsearchStep = step => step.type === 'elasticsearch';
exports.isElasticsearchStep = isElasticsearchStep;
const isKibanaStep = step => step.type === 'kibana';
exports.isKibanaStep = isKibanaStep;
const isForeachStep = step => step.type === 'foreach';
exports.isForeachStep = isForeachStep;
const isIfStep = step => step.type === 'if';
exports.isIfStep = isIfStep;
const isParallelStep = step => step.type === 'parallel';
exports.isParallelStep = isParallelStep;
const isMergeStep = step => step.type === 'merge';
exports.isMergeStep = isMergeStep;
const isBuiltInStepType = type => _schema.BuiltInStepTypes.includes(type);
exports.isBuiltInStepType = isBuiltInStepType;
const isTriggerType = type => _schema.TriggerTypes.includes(type);
exports.isTriggerType = isTriggerType;