"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowLevelOnFailureNodeSchema = exports.StepLevelOnFailureNodeSchema = exports.OnFailureNodeSchema = exports.ExitTryBlockNodeSchema = exports.ExitTimeoutZoneNodeSchema = exports.ExitRetryNodeSchema = exports.ExitNormalPathNodeSchema = exports.ExitFallbackPathNodeSchema = exports.ExitContinueNodeSchema = exports.EnterTryBlockNodeSchema = exports.EnterTimeoutZoneNodeSchema = exports.EnterRetryNodeSchema = exports.EnterNormalPathNodeSchema = exports.EnterFallbackPathNodeSchema = exports.EnterContinueNodeSchema = void 0;
var _zod = require("@kbn/zod");
var _schema = require("../../../spec/schema");
var _base = require("./base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EnterContinueNodeSchema = exports.EnterContinueNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('enter-continue'),
  exitNodeId: _zod.z.string()
});
const ExitContinueNodeSchema = exports.ExitContinueNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('exit-continue')
});
const EnterRetryNodeSchema = exports.EnterRetryNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('enter-retry'),
  exitNodeId: _zod.z.string(),
  configuration: _schema.WorkflowRetrySchema
});
const ExitRetryNodeSchema = exports.ExitRetryNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('exit-retry'),
  startNodeId: _zod.z.string()
});
const EnterTryBlockNodeSchema = exports.EnterTryBlockNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('enter-try-block'),
  enterNormalPathNodeId: _zod.z.string(),
  exitNodeId: _zod.z.string()
});
const ExitTryBlockNodeSchema = exports.ExitTryBlockNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('exit-try-block'),
  enterNodeId: _zod.z.string()
});
const EnterNormalPathNodeSchema = exports.EnterNormalPathNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('enter-normal-path'),
  enterZoneNodeId: _zod.z.string(),
  enterFailurePathNodeId: _zod.z.string()
});
const ExitNormalPathNodeSchema = exports.ExitNormalPathNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('exit-normal-path'),
  exitOnFailureZoneNodeId: _zod.z.string(),
  enterNodeId: _zod.z.string()
});
const EnterFallbackPathNodeSchema = exports.EnterFallbackPathNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('enter-fallback-path'),
  enterZoneNodeId: _zod.z.string()
});
const ExitFallbackPathNodeSchema = exports.ExitFallbackPathNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('exit-fallback-path'),
  exitOnFailureZoneNodeId: _zod.z.string(),
  enterNodeId: _zod.z.string()
});
const OnFailureNodeSchema = exports.OnFailureNodeSchema = _base.GraphNodeSchema.extend({
  type: _zod.z.literal('on-failure')
});
const StepLevelOnFailureNodeSchema = exports.StepLevelOnFailureNodeSchema = _base.GraphNodeSchema.extend({
  type: _zod.z.literal('step-level-on-failure')
});
const WorkflowLevelOnFailureNodeSchema = exports.WorkflowLevelOnFailureNodeSchema = _base.GraphNodeSchema.extend({
  type: _zod.z.literal('workflow-level-on-failure')
});
// Timeout handling nodes - stack-based timeout management
const EnterTimeoutZoneNodeSchema = exports.EnterTimeoutZoneNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('enter-timeout-zone'),
  timeout: _zod.z.string(),
  stepType: _zod.z.union([_zod.z.literal('workflow_level_timeout'), _zod.z.literal('step_level_timeout')])
});
const ExitTimeoutZoneNodeSchema = exports.ExitTimeoutZoneNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('exit-timeout-zone'),
  stepType: _zod.z.union([_zod.z.literal('workflow_level_timeout'), _zod.z.literal('step_level_timeout')])
});