"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExitForeachNodeSchema = exports.EnterForeachNodeSchema = exports.EnterForeachNodeConfigurationSchema = void 0;
var _zod = require("@kbn/zod");
var _schema = require("../../../spec/schema");
var _base = require("./base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EnterForeachNodeConfigurationSchema = exports.EnterForeachNodeConfigurationSchema = _schema.ForEachStepSchema.omit({
  steps: true
});
const EnterForeachNodeSchema = exports.EnterForeachNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('enter-foreach'),
  exitNodeId: _zod.z.string(),
  configuration: EnterForeachNodeConfigurationSchema
});
const ExitForeachNodeSchema = exports.ExitForeachNodeSchema = _base.GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('exit-foreach'),
  startNodeId: _zod.z.string()
});