"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaitGraphNodeSchema = exports.KibanaGraphNodeSchema = exports.HttpGraphNodeSchema = exports.GraphNodeSchema = exports.ElasticsearchGraphNodeSchema = exports.AtomicGraphNodeSchema = void 0;
var _zod = require("@kbn/zod");
var _schema = require("../../../spec/schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const GraphNodeSchema = exports.GraphNodeSchema = _zod.z.object({
  id: _zod.z.string(),
  type: _zod.z.string(),
  stepId: _zod.z.string(),
  stepType: _zod.z.string()
});
const AtomicGraphNodeSchema = exports.AtomicGraphNodeSchema = GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('atomic'),
  configuration: _zod.z.any()
});
const WaitGraphNodeSchema = exports.WaitGraphNodeSchema = GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('wait'),
  configuration: _schema.WaitStepSchema
});
const HttpGraphNodeSchema = exports.HttpGraphNodeSchema = GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.literal('http'),
  configuration: _schema.HttpStepSchema
});
const ElasticsearchGraphNodeSchema = exports.ElasticsearchGraphNodeSchema = GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.string().refine(val => val.startsWith('elasticsearch.'), {
    message: 'Elasticsearch graph node type must start with "elasticsearch."'
  }),
  configuration: _schema.ElasticsearchStepSchema
});
const KibanaGraphNodeSchema = exports.KibanaGraphNodeSchema = GraphNodeSchema.extend({
  id: _zod.z.string(),
  type: _zod.z.string().refine(val => val.startsWith('kibana.'), {
    message: 'Kibana graph node type must start with "kibana."'
  }),
  configuration: _schema.KibanaStepSchema
});