"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isWait = exports.isKibana = exports.isHttp = exports.isExitWorkflowTimeoutZone = exports.isExitTryBlock = exports.isExitStepTimeoutZone = exports.isExitRetry = exports.isExitNormalPath = exports.isExitIf = exports.isExitForeach = exports.isExitContinue = exports.isExitConditionBranch = exports.isEnterWorkflowTimeoutZone = exports.isEnterTryBlock = exports.isEnterStepTimeoutZone = exports.isEnterRetry = exports.isEnterNormalPath = exports.isEnterIf = exports.isEnterForeach = exports.isEnterContinue = exports.isEnterConditionBranch = exports.isElasticsearch = exports.isAtomic = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isAtomic = node => node.type === 'atomic';
exports.isAtomic = isAtomic;
const isElasticsearch = node => node.type.startsWith('elasticsearch.');
exports.isElasticsearch = isElasticsearch;
const isKibana = node => node.type.startsWith('kibana.');
exports.isKibana = isKibana;
const isHttp = node => node.type === 'http';
exports.isHttp = isHttp;
const isWait = node => node.type === 'wait';
exports.isWait = isWait;
const isEnterIf = node => node.type === 'enter-if';
exports.isEnterIf = isEnterIf;
const isExitIf = node => node.type === 'exit-if';
exports.isExitIf = isExitIf;
const isEnterConditionBranch = node => node.type === 'enter-condition-branch';
exports.isEnterConditionBranch = isEnterConditionBranch;
const isExitConditionBranch = node => node.type === 'exit-condition-branch';
exports.isExitConditionBranch = isExitConditionBranch;
const isEnterForeach = node => node.type === 'enter-foreach';
exports.isEnterForeach = isEnterForeach;
const isExitForeach = node => node.type === 'exit-foreach';
exports.isExitForeach = isExitForeach;
const isEnterRetry = node => node.type === 'enter-retry';
exports.isEnterRetry = isEnterRetry;
const isExitRetry = node => node.type === 'exit-retry';
exports.isExitRetry = isExitRetry;
const isEnterContinue = node => node.type === 'enter-continue';
exports.isEnterContinue = isEnterContinue;
const isExitContinue = node => node.type === 'exit-continue';
exports.isExitContinue = isExitContinue;
const isEnterTryBlock = node => node.type === 'enter-try-block';
exports.isEnterTryBlock = isEnterTryBlock;
const isExitTryBlock = node => node.type === 'exit-try-block';
exports.isExitTryBlock = isExitTryBlock;
const isEnterNormalPath = node => node.type === 'enter-normal-path';
exports.isEnterNormalPath = isEnterNormalPath;
const isExitNormalPath = node => node.type === 'exit-normal-path';
exports.isExitNormalPath = isExitNormalPath;
const isEnterWorkflowTimeoutZone = node => node.type === 'enter-timeout-zone' && node.stepType === 'workflow_level_timeout';
exports.isEnterWorkflowTimeoutZone = isEnterWorkflowTimeoutZone;
const isExitWorkflowTimeoutZone = node => node.type === 'exit-timeout-zone' && node.stepType === 'workflow_level_timeout';
exports.isExitWorkflowTimeoutZone = isExitWorkflowTimeoutZone;
const isEnterStepTimeoutZone = node => node.type === 'enter-timeout-zone' && node.stepType !== 'workflow_level_timeout';
exports.isEnterStepTimeoutZone = isEnterStepTimeoutZone;
const isExitStepTimeoutZone = node => node.type === 'exit-timeout-zone' && node.stepType !== 'workflow_level_timeout';
exports.isExitStepTimeoutZone = isExitStepTimeoutZone;