"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchWorkflowExecutions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const searchWorkflowExecutions = async ({
  esClient,
  logger,
  workflowExecutionIndex,
  query,
  sort = [{
    createdAt: 'desc'
  }]
}) => {
  try {
    logger.info(`Searching workflow executions in index ${workflowExecutionIndex}`);
    const response = await esClient.search({
      index: workflowExecutionIndex,
      query,
      sort
    });
    return transformToWorkflowExecutionListModel(response);
  } catch (error) {
    logger.error(`Failed to search workflow executions: ${error}`);
    throw error;
  }
};
exports.searchWorkflowExecutions = searchWorkflowExecutions;
function transformToWorkflowExecutionListModel(response) {
  return {
    results: response.hits.hits.map(hit => {
      const workflowExecution = hit._source;
      return {
        spaceId: workflowExecution.spaceId,
        id: hit._id,
        stepId: workflowExecution.stepId,
        status: workflowExecution.status,
        startedAt: workflowExecution.startedAt,
        finishedAt: workflowExecution.finishedAt,
        duration: workflowExecution.duration,
        workflowId: workflowExecution.workflowId,
        triggeredBy: workflowExecution.triggeredBy
      };
    }),
    _pagination: {
      limit: response.hits.hits.length,
      page: 1,
      total: response.hits.hits.length
    }
  };
}