"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WORKFLOWS_STEP_EXECUTIONS_INDEX_MAPPINGS = exports.WORKFLOWS_INDEX_MAPPINGS = exports.WORKFLOWS_EXECUTIONS_INDEX_MAPPINGS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// address ecs@mapping in the future: https://github.com/elastic/kibana/pull/228259/#discussion_r2218755096
const WORKFLOWS_INDEX_MAPPINGS = exports.WORKFLOWS_INDEX_MAPPINGS = {
  dynamic: false,
  properties: {
    spaceId: {
      type: 'keyword'
    },
    id: {
      type: 'keyword'
    },
    name: {
      type: 'text',
      fields: {
        keyword: {
          type: 'keyword',
          ignore_above: 256
        }
      }
    },
    description: {
      type: 'text',
      fields: {
        keyword: {
          type: 'keyword',
          ignore_above: 256
        }
      }
    },
    status: {
      type: 'keyword'
    },
    tags: {
      type: 'keyword'
    },
    createdAt: {
      type: 'date'
    },
    createdBy: {
      type: 'keyword'
    },
    lastUpdatedAt: {
      type: 'date'
    },
    lastUpdatedBy: {
      type: 'keyword'
    },
    definition: {
      type: 'object',
      enabled: false
    },
    yaml: {
      type: 'text'
    }
  }
};
const WORKFLOWS_EXECUTIONS_INDEX_MAPPINGS = exports.WORKFLOWS_EXECUTIONS_INDEX_MAPPINGS = {
  dynamic: false,
  properties: {
    spaceId: {
      type: 'keyword'
    },
    id: {
      type: 'keyword'
    },
    workflowId: {
      type: 'keyword'
    },
    status: {
      type: 'keyword'
    },
    workflowDefinition: {
      type: 'object',
      enabled: false
    },
    createdAt: {
      type: 'date'
    },
    error: {
      type: 'text',
      index: false
    },
    createdBy: {
      type: 'keyword'
    },
    startedAt: {
      type: 'date'
    },
    finishedAt: {
      type: 'date'
    },
    duration: {
      type: 'long'
    },
    triggeredBy: {
      type: 'keyword'
    }
  }
};
const WORKFLOWS_STEP_EXECUTIONS_INDEX_MAPPINGS = exports.WORKFLOWS_STEP_EXECUTIONS_INDEX_MAPPINGS = {
  dynamic: false,
  properties: {
    spaceId: {
      type: 'keyword'
    },
    id: {
      type: 'keyword'
    },
    stepId: {
      type: 'keyword'
    },
    workflowRunId: {
      type: 'keyword'
    },
    workflowId: {
      type: 'keyword'
    },
    status: {
      type: 'keyword'
    },
    startedAt: {
      type: 'date'
    },
    finishedAt: {
      type: 'date'
    },
    duration: {
      // milliseconds
      type: 'long'
    },
    output: {
      type: 'object',
      enabled: false
    }
  }
};