"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWorkflowExecution = void 0;
var _yaml_utils = require("../../../common/lib/yaml_utils");
var _search_step_executions = require("./search_step_executions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getWorkflowExecution = async ({
  esClient,
  logger,
  workflowExecutionIndex,
  stepsExecutionIndex,
  workflowExecutionId,
  spaceId
}) => {
  try {
    var _response$hits$hits$;
    const response = await esClient.search({
      index: workflowExecutionIndex,
      query: {
        bool: {
          must: [{
            ids: {
              values: [workflowExecutionId]
            }
          }, {
            term: {
              spaceId
            }
          }]
        }
      }
    });
    const hit = (_response$hits$hits$ = response.hits.hits[0]) !== null && _response$hits$hits$ !== void 0 ? _response$hits$hits$ : null;
    if (!hit || !hit._source) {
      return null;
    }
    const stepExecutions = await (0, _search_step_executions.searchStepExecutions)({
      esClient,
      logger,
      stepsExecutionIndex,
      workflowExecutionId,
      spaceId
    });
    return transformToWorkflowExecutionDetailDto(hit._id, hit._source, stepExecutions, logger);
  } catch (error) {
    logger.error(`Failed to get workflow: ${error}`);
    throw error;
  }
};
exports.getWorkflowExecution = getWorkflowExecution;
function transformToWorkflowExecutionDetailDto(id, workflowExecution, stepExecutions, logger) {
  let yaml = workflowExecution.yaml;
  // backward compatibility for workflow executions created before yaml was added to the workflow execution object
  try {
    if (!yaml) {
      yaml = (0, _yaml_utils.stringifyWorkflowDefinition)(workflowExecution.workflowDefinition);
    }
  } catch (error) {
    logger.error(`Failed to stringify workflow definition: ${error}`);
    yaml = '';
  }
  return {
    ...workflowExecution,
    id,
    stepId: workflowExecution.stepId,
    stepExecutions,
    triggeredBy: workflowExecution.triggeredBy,
    // <-- Include the triggeredBy field
    yaml
  };
}