"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFeatures = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The order of appearance in the feature privilege page
 * under the management section.
 */
const FEATURE_ORDER = 3000;
const registerFeatures = plugins => {
  var _plugins$features;
  (_plugins$features = plugins.features) === null || _plugins$features === void 0 ? void 0 : _plugins$features.registerKibanaFeature({
    app: [],
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.kibana,
    id: 'workflowsManagement',
    name: _i18n.i18n.translate('platform.plugins.shared.workflows_management.featureRegistry.workflowsManagementFeatureName', {
      defaultMessage: 'Workflows'
    }),
    order: FEATURE_ORDER,
    privileges: {
      all: {
        app: [],
        api: ['create', 'update', 'delete', 'read'],
        savedObject: {
          all: ['workflows', 'workflow_executions'],
          read: []
        },
        ui: ['create', 'update', 'delete', 'read', 'execute']
      },
      read: {
        app: [],
        api: ['read'],
        savedObject: {
          all: [],
          read: ['workflows', 'workflow_executions']
        },
        ui: ['read']
      }
    },
    subFeatures: [{
      name: _i18n.i18n.translate('platform.plugins.shared.workflows_management.featureRegistry.workflowsManagementSubFeatureName', {
        defaultMessage: 'Workflows Actions'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          api: ['workflow:create'],
          id: 'workflow_create',
          name: _i18n.i18n.translate('platform.plugins.shared.workflows_management.featureRegistry.createWorkflowSubFeaturePrivilege', {
            defaultMessage: 'Create'
          }),
          includeIn: 'all',
          savedObject: {
            all: ['workflow'],
            read: []
          },
          ui: ['createWorkflow']
        }, {
          api: ['workflow:update'],
          id: 'workflow_update',
          name: _i18n.i18n.translate('platform.plugins.shared.workflows_management.featureRegistry.updateWorkflowSubFeaturePrivilege', {
            defaultMessage: 'Update'
          }),
          includeIn: 'all',
          savedObject: {
            all: ['workflow'],
            read: []
          },
          ui: ['updateWorkflow']
        }, {
          api: ['workflow:delete'],
          id: 'workflow_delete',
          name: _i18n.i18n.translate('platform.plugins.shared.workflows_management.featureRegistry.deleteWorkflowSubFeaturePrivilege', {
            defaultMessage: 'Delete'
          }),
          includeIn: 'all',
          savedObject: {
            all: ['workflow'],
            read: []
          },
          ui: ['deleteWorkflow']
        }, {
          api: ['workflow:execute'],
          id: 'workflow_execute',
          name: _i18n.i18n.translate('platform.plugins.shared.workflows_management.featureRegistry.executeWorkflowSubFeaturePrivilege', {
            defaultMessage: 'Execute'
          }),
          includeIn: 'all',
          savedObject: {
            all: ['workflow_execution'],
            read: ['workflow']
          },
          ui: ['executeWorkflow']
        }, {
          api: ['workflow:read'],
          id: 'workflow_read',
          name: _i18n.i18n.translate('platform.plugins.shared.workflows_management.featureRegistry.readWorkflowSubFeaturePrivilege', {
            defaultMessage: 'Read'
          }),
          includeIn: 'read',
          savedObject: {
            read: ['workflow'],
            all: []
          },
          ui: ['readWorkflow']
        }, {
          api: ['workflow_execution:read'],
          id: 'workflow_execution_read',
          name: _i18n.i18n.translate('platform.plugins.shared.workflows_management.featureRegistry.readWorkflowExecutionSubFeaturePrivilege', {
            defaultMessage: 'Read Workflow Execution'
          }),
          includeIn: 'read',
          savedObject: {
            read: ['workflow_execution'],
            all: []
          },
          ui: ['readWorkflowExecution']
        }, {
          api: ['workflow_execution:cancel'],
          id: 'workflow_execution_cancel',
          name: _i18n.i18n.translate('platform.plugins.shared.workflows_management.featureRegistry.cancelWorkflowExecutionSubFeaturePrivilege', {
            defaultMessage: 'Cancel Workflow Execution'
          }),
          includeIn: 'all',
          savedObject: {
            read: ['workflow_execution'],
            all: []
          },
          ui: ['cancelWorkflowExecution']
        }]
      }]
    }]
  });
};
exports.registerFeatures = registerFeatures;