"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WORKFLOWS_MANAGEMENT_URL_REQUIRED = exports.PASSWORD_REQUIRED_WHEN_USER_PROVIDED = exports.NAME = exports.INVALID_URL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const NAME = exports.NAME = _i18n.i18n.translate('xpack.stackConnectors.workflows.title', {
  defaultMessage: 'Workflows'
});
const WORKFLOWS_MANAGEMENT_URL_REQUIRED = exports.WORKFLOWS_MANAGEMENT_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.workflows.error.requiredWorkflowsManagementUrlText', {
  defaultMessage: 'Workflows Management URL is required.'
});
const INVALID_URL = (url, err) => _i18n.i18n.translate('xpack.stackConnectors.workflows.error.invalidUrlErrorMessage', {
  defaultMessage: 'Invalid URL {url}. Error: {err}',
  values: {
    url,
    err
  }
});
exports.INVALID_URL = INVALID_URL;
const PASSWORD_REQUIRED_WHEN_USER_PROVIDED = exports.PASSWORD_REQUIRED_WHEN_USER_PROVIDED = _i18n.i18n.translate('xpack.stackConnectors.workflows.error.passwordRequiredWhenUserProvidedText', {
  defaultMessage: 'Password is required when username is provided.'
});