"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createExternalService = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Type for the workflows service function that should be injected

const createExternalService = (_actionId, logger, _configurationUtilities, _connectorUsageCollector, request, runWorkflowService) => {
  const runWorkflow = async ({
    workflowId,
    spaceId,
    inputs = {}
  }) => {
    try {
      logger.info(`Attempting to run workflow ${workflowId} via internal service`);
      if (!runWorkflowService) {
        throw new Error('Workflows service not available. This connector requires workflows management plugin to be enabled.');
      }

      // Use the injected service function instead of making HTTP requests
      const workflowRunId = await runWorkflowService(workflowId, spaceId, inputs, request);
      if (!workflowRunId) {
        throw new Error('Invalid response: missing workflowRunId');
      }
      logger.info(`Successfully started workflow ${workflowId}, run ID: ${workflowRunId}`);
      return {
        workflowRunId,
        status: 'executed'
      };
    } catch (error) {
      logger.error(`Error running workflow ${workflowId}: ${error.message}`);
      throw (0, _utils.createServiceError)(error, `Unable to run workflow ${workflowId}`);
    }
  };
  return {
    runWorkflow
  };
};
exports.createExternalService = createExternalService;