"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowsRuleActionParamsSchema = exports.ExecutorSubActionRunParamsSchema = exports.ExecutorParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const RunSubActionParamsSchema = _configSchema.schema.object({
  workflowId: _configSchema.schema.string(),
  inputs: _configSchema.schema.maybe(_configSchema.schema.any()),
  alerts: _configSchema.schema.arrayOf(_configSchema.schema.any()),
  spaceId: _configSchema.schema.string()
});

// Schema for rule configuration (what the UI saves)
const WorkflowsRuleActionParamsSchema = exports.WorkflowsRuleActionParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('run'),
  subActionParams: _configSchema.schema.object({
    workflowId: _configSchema.schema.string(),
    inputs: _configSchema.schema.maybe(_configSchema.schema.any())
  })
});

// Schema for execution (what the executor receives)
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('run'),
  subActionParams: RunSubActionParamsSchema
});
const ExecutorSubActionRunParamsSchema = exports.ExecutorSubActionRunParamsSchema = RunSubActionParamsSchema;