"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorTypeId = void 0;
exports.executor = executor;
exports.getConnectorType = getConnectorType;
exports.getWorkflowsConnectorAdapter = getWorkflowsConnectorAdapter;
var _common = require("@kbn/actions-plugin/common");
var _configSchema = require("@kbn/config-schema");
var _api = require("./api");
var _schema = require("./schema");
var _service = require("./service");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const supportedSubActions = ['run'];
const ConnectorTypeId = exports.ConnectorTypeId = '.workflows';

// Interface for dependency injection, similar to GetCasesConnectorTypeArgs

// connector type definition
function getConnectorType(deps) {
  return {
    id: ConnectorTypeId,
    minimumLicenseRequired: 'gold',
    name: i18n.NAME,
    validate: {
      params: {
        schema: _schema.ExecutorParamsSchema
      },
      config: {
        schema: _configSchema.schema.object({})
      },
      secrets: {
        schema: _configSchema.schema.object({})
      }
    },
    executor: execOptions => executor(execOptions, deps),
    supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.SecurityConnectorFeatureId],
    isSystemActionType: true
  };
}

// action executor
async function executor(execOptions, deps) {
  const {
    actionId,
    configurationUtilities,
    params,
    logger,
    connectorUsageCollector,
    request
  } = execOptions;
  const {
    subAction,
    subActionParams
  } = params;
  let data;

  // Get the workflows service function if available
  let workflowsServiceFunction;
  if (deps !== null && deps !== void 0 && deps.getWorkflowsService && request) {
    try {
      workflowsServiceFunction = await deps.getWorkflowsService(request);
    } catch (error) {
      logger.error(`Failed to get workflows service: ${error.message}`);
    }
  }
  const externalService = (0, _service.createExternalService)(actionId, logger, configurationUtilities, connectorUsageCollector, request, workflowsServiceFunction);
  if (!_api.api[subAction]) {
    const errorMessage = `[WorkflowsConnector][Action][ExternalService] Unsupported subAction type ${subAction}.`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }
  if (!supportedSubActions.includes(subAction)) {
    const errorMessage = `[WorkflowsConnector][Action][ExternalService] subAction ${subAction} not implemented.`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }
  if (subAction === 'run') {
    const runParams = subActionParams;
    data = await _api.api.run({
      externalService,
      params: runParams,
      logger
    });
    logger.debug(`response run workflow for workflow id: ${data.workflowRunId}`);
  }
  return {
    status: 'ok',
    data,
    actionId
  };
}

// Connector adapter for system action
function getWorkflowsConnectorAdapter() {
  return {
    connectorTypeId: ConnectorTypeId,
    ruleActionParamsSchema: _schema.WorkflowsRuleActionParamsSchema,
    buildActionParams: ({
      alerts,
      rule,
      params,
      ruleUrl,
      spaceId
    }) => {
      try {
        const subActionParams = params === null || params === void 0 ? void 0 : params.subActionParams;
        if (!subActionParams) {
          throw new Error(`Missing subActionParams. Received: ${JSON.stringify(params)}`);
        }
        const {
          workflowId
        } = subActionParams;
        if (!workflowId) {
          throw new Error(`Missing required workflowId parameter. Received params: ${JSON.stringify(params)}`);
        }

        // Extract only new alerts for workflow execution (similar to Cases pattern)
        const workflowAlerts = [...alerts.new.data];

        // Merge alert context with user inputs
        const alertContext = {
          alerts: {
            new: alerts.new
          },
          rule: {
            id: rule.id,
            name: rule.name,
            tags: rule.tags,
            consumer: rule.consumer,
            producer: rule.producer,
            ruleTypeId: rule.ruleTypeId
          },
          ruleUrl,
          spaceId
        };
        return {
          subAction: 'run',
          subActionParams: {
            workflowId,
            alerts: workflowAlerts,
            inputs: {
              event: alertContext
            },
            spaceId
          }
        };
      } catch (error) {
        var _params$subActionPara;
        return {
          subAction: 'run',
          subActionParams: {
            workflowId: (params === null || params === void 0 ? void 0 : (_params$subActionPara = params.subActionParams) === null || _params$subActionPara === void 0 ? void 0 : _params$subActionPara.workflowId) || 'unknown',
            alerts: [],
            spaceId
          }
        };
      }
    }
  };
}